---
title: Lists
localeTitle: Списки
---
**TODO: `list` основных сведений**

[Документы Python - Списки](https://docs.python.org/3/library/stdtypes.html#lists)

**Создание:**

Пустой `list` создается с помощью пары квадратных скобок:

```shell
>>> empty_list = [] 
 >>> type(empty_list) 
 <class 'list'> 
 >>> len(empty_list) 
 0 
```

`list` может быть создан с помощью элементов, заключая в список разделенных запятыми элементов с квадратными скобками. Списки позволяют использовать элементы разных типов (гетерогенные), но чаще всего однотипные (однородные):

```shell
>>> homogeneous_list = [1, 1, 2, 3, 5, 8] 
 >>> type(homogeneous_list) 
 <class 'list'> 
 >>> print(homogeneous_list) 
 [1, 1, 2, 3, 5, 8] 
 >>> len(homogeneous_list) 
 6 
 >>> heterogeneous_list = [1, "Hello Campers!"] 
 >>> print(heterogeneous_list) 
 [1, "Hello Campers!"] 
 >>> len(heterogeneous_list) 
 2 
```

Конструктор `list` также можно использовать для создания `list` :

```shell
>>> empty_list = list()                            # Creates an empty list 
 >>> print(empty_list) 
 [] 
 >>> list_from_iterable = list("Hello campers!")    # Creates a list from an iterable. 
 >>> print(list_from_iterable) 
 ['H', 'e', 'l', 'l', 'o', ' ', 'c', 'a', 'm', 'p', 'e', 'r', 's', '!'] 
```

**Доступ к элементам `list` :**

```shell
>>> my_list = [1, 2, 9, 16, 25] 
 >>> print(my_list) 
 [1, 2, 9, 16, 25] 
```

_Нулевой индекс_

```shell
>>> my_list[0] 
 1 
 >>> my_list[1] 
 2 
 >>> my_list[2] 
 9 
```

_Обтекание индексации_

```shell
>>> my_list[-1] 
 25 
 >>> my_list[-2] 
 16 
```

_Распаковка списков для python-3_

```shell
>>> print(*my_list) 
 1 2 9 16 25 
```

**Mutable:**

`lists` являются изменяемыми контейнерами. Конвертируемые контейнеры представляют собой контейнеры, которые допускают внесение изменений в объекты, содержащиеся в контейнере. **TODO: ДОБАВИТЬ БОЛЬШЕ?**

_Переустановка элементов в списке_

Элементы из `list` могут быть извлечены и перенастроены с использованием другого `list` качестве индекса.

```shell
>>> my_list = [1, 2, 9, 16, 25, 34, 53, 21] 
 >>> my_index = [5, 2, 0] 
 >>> my_new_list = [my_list[i] for i in my_index] 
 >>> print(my_new_list) 
 [34, 9, 1] 
```

**TODO: Какие из них следует обсудить здесь:**

[Документы Python - дополнительные сведения о списках](https://docs.python.org/3/tutorial/datastructures.html#more-on-lists)

*   `list.append(x)` Добавить элемент в конец списка. Эквивалентен \[len (a):\] = \[x\].
    
*   `list.extend(L)` Расширить список, добавив все элементы в данный список. Эквивалентен \[len (a):\] = L.
    
*   `list.insert(i, x)` Вставить элемент в заданную позицию. Первый аргумент - это индекс элемента, перед которым нужно вставить, поэтому a.insert (0, x) вставлен в начале списка, а a.insert (len (a), x) эквивалентен a.append ( Икс).
    
*   `list.remove(x)` Удалить первый элемент из списка, значение которого равно x. Это ошибка, если такой элемент отсутствует.
    
*   `list.pop([i])` Удалите элемент в указанной позиции в списке и верните его. Если индекс не указан, a.pop () удаляет и возвращает последний элемент в списке. (Квадратные скобки вокруг i в сигнатуре метода означают, что параметр является необязательным, а не то, что вы должны вводить квадратные скобки в этой позиции. Вы часто увидите эту нотацию в Справочнике по библиотеке Python.)
    
*   `list.clear()` Удалить все элементы из списка. Эквивалентен del a \[:\].
    
*   `list.index(x)` Возвращает индекс в списке первого элемента, значение которого равно x. Это ошибка, если такой элемент отсутствует.
    
*   `list.count(x)` Возвращает количество раз, когда x отображается в списке.
    
*   `list.sort(key=None, reverse=False)` Сортировка элементов списка на месте (аргументы могут использоваться для настройки сортировки, см. sorted () для их объяснения).
    
*   `list.reverse()` элементы списка на место.
    
*   `list.copy()` Верните мелкую копию списка. Эквивалентен \[:\].