---
title: List Comprehension
localeTitle: Учет списка
---
## Учет списка

List Comprehension - это способ перебирать список, чтобы создать новый список, основанный на некоторых условиях. Сначала это может сбивать с толку, но как только вы приспосабливаетесь к синтаксису, он очень мощный и быстрый.

Первым шагом в обучении использованию понимания списка является просмотр традиционного способа перебора списка. Ниже приведен простой пример, который возвращает новый список четных чисел.

```python
# Example list for demonstration 
 some_list = [1, 2, 5, 7, 8, 10] 
 
 # Empty list that will be populate with a loop 
 even_list = [] 
 
 for number in some_list: 
  if number % 2 == 0: 
    even_list.append(number) 
 
 # even_list now equals [2, 8, 10] 
```

Сначала создается список с некоторыми числами. Затем вы создаете пустой список, который будет удерживать ваши результаты в цикле. В цикле вы проверяете, является ли каждое число делимым на 2, и если вы добавите его в список четных. Это заняло 5 строк кода, не включая комментарии и пробелы, что в этом примере мало.

Теперь для примера понимания списка.

```python
# Example list for demonstration 
 some_list = [1, 2, 5, 7, 8, 10] 
 
 # List Comprehension 
 even_list = [number for number in some_list if number % 2 == 0] 
 
 # even_list now equals [2, 8, 10] 
```

Другой пример, с теми же двумя шагами: Ниже будет создан список номеров, соответствующих номерам в `my_starting_list` умноженном на 7.

```py
my_starting_list = [1, 2, 3, 4, 5, 6, 7, 8] 
 my_new_list = [] 
 
 for item in my_starting_list: 
 my_new_list.append(item * 7) 
```

Когда этот код запускается, конечным значением `my_new_list` является: `[7, 14, 21, 28, 35, 42, 49, 56]`

Разработчик, использующий понимание списков, может достичь того же результата, используя следующее понимание списка, которое приводит к тому же `my_new_list` .

```py
my_starting_list = [1, 2, 3, 4, 5, 6, 7, 8] 
 
 my_new_list = [item * 7 for item in my_starting_list] 
```

Простая формула для записи в способе составления списка:

`my_list = [{operation with input n} for n in {python iterable}]`

Замените `{operation with input n}` однако вы хотите изменить элемент, возвращенный из итерабельного. В приведенном выше примере используется `n * 7` но операция может быть как простой, так и сложной по мере необходимости.

Замените `{python iterable}` любым итерабельным. [Типы последовательности](https://guide.freecodecamp.org/python/sequence-types) будут наиболее распространены. Список был использован в приведенном выше примере, но кортежи и диапазоны также распространены.

Понимание списка добавляет элемент из существующего списка в новый список, если выполняется какое-либо условие. Он более аккуратный, но в большинстве случаев он намного быстрее. В некоторых случаях понимание списка может затруднять читаемость, поэтому разработчик должен взвесить свои параметры, когда вы выбираете использование списка.

## Примеры понимания списка с помощью условных выражений

Поток управления в списках можно контролировать с помощью условных выражений. Для exmaple:

```py
only_even_list = [i for i in range(13) if i%2==0] 
```

Это эквивалентно следующему циклу:

```py
only_even_list = list() 
 for i in range(13): 
  if i%2 == 0: 
    only_even_list.append(i) 
```

Учет списка также может содержать вложенные условия. Рассмотрим следующий цикл:

```py
divisible = list() 
 for i in range(50): 
  if i%2 == 0: 
    if i%3 == 0: 
      divisible.append(i) 
```

Используя понимание списка, это можно записать так:

```py
divisible = [i for i in range(50) if i%2==0 if i%3==0] 
```

Оператор If-Else также может использоваться вместе со списком.

```py
list_1 = [i if i%2==0 else i*-1 for i in range(10)] 
```

#### Дополнительная информация:

[Структуры данных Python - Списки](https://docs.python.org/2.7/tutorial/datastructures.html)

[Python for Loops](https://guide.freecodecamp.org/python/for-loop-statements)

[Списки Python](https://guide.freecodecamp.org/python/learn-about-python-lists)

[Python для начинающих - список понятий](http://www.pythonforbeginners.com/basics/list-comprehensions-in-python)