---
title: List Index Method
localeTitle: Метод индекса списка
---
## Метод индекса списка

Среди множества функций, которые входят вместе со структурой данных списка, `index()` возвращает первое вхождение / индекс элемента в списке, заданном как аргумент функции.

Списки представляют собой самую основную структуру данных Python и сохраняют список значений по порядку (по сравнению со словарями, порядок которых не имеет значения). Мы извлекаем элементы по числовому индексу.

Имея в виду тот факт, что индексирование начинается с 0 или первый элемент считается индексом 0, давайте посмотрим на некоторые примеры.

#### Пример использования:

```py
numbers = [1, 2, 2, 3, 9, 5, 6, 10] 
 words = ["I", "love", "Python", "I", "love"] 
 
 print(numbers.index(9)) 
 print(numbers.index(2)) 
 print(words.index("I")) 
 print(words.index("am")) 
```

##### Вывод:

```py
4 
 1 
 0 
 Traceback (most recent call last): 
  File "<stdin>", line 1, in <module> 
 ValueError: 'am' is not in list 
```

Здесь первый вывод очень очевиден, но второй и третий могут показаться запутанными вначале. Но помните, что `index()` возвращает первое вхождение элемента и, следовательно, в этом случае `1` и `0` являются индексами, где `2` и `"I"` встречаются первыми в списках соответственно.

Кроме того, если элемент не найден в списке, возвращается значение `ValueError` как в случае индексации `"am"` в списке `words` .

#### Дополнительные аргументы:

Вы также можете использовать необязательные аргументы, чтобы ограничить поиск определенной подпоследовательностью списка, как показано в этом примере:

```py
words = ["I","am", "a", "I", "am", "Pythonista"] 
 
 print(words.index("am",2,5)) 
```

##### Вывод:
```
4 
```

Здесь, хотя элемент выполняется поиск между индексами 2 (включительно) и 5 ​​(не включительно), но возвращаемый индекс вычисляется относительно начала полного списка, а не аргумента start.

#### Дополнительная информация:

Официальную документацию для `index()` можно найти [здесь](https://docs.python.org/3.6/tutorial/datastructures.html)