---
title: List Sort Method
localeTitle: Метод сортировки списка
---
## Метод сортировки списка

Списки Python имеют встроенный метод `sort()` который изменяет список на месте и функцию `sorted()` которая создает новый отсортированный список из итерабельного.

list.sort (key = ..., reverse = \[True / False\])

### параметры

Для этого метода есть два необязательных параметра _key_ - входное значение для ключевого параметра должно быть функцией, которая принимает один аргумент и возвращает значение, используемое для сравнения, для сортировки элементов в списке _обратное = \[значение\]_ _value = True_ : сортирует элементы в списке в порядке убывания _value = False_ : сортирует элементы в списке в порядке возрастания. Это считается значением по умолчанию. Обратите внимание, что метод `sort()` не возвращает никакого значения. Он изменяет исходный список.

### Пример использования

```py
a = [4, 2, 5, 3, 1] 
 a.sort() 
 print a # prints [1, 2, 3, 4, 5] 
 
 b = ['free', 'code', 'camp'] 
 b.sort() 
 print b # prints ['camp', 'code', 'free'] 
```

Рассмотрим пример с **обратным** параметром

```py
a = [4, 2, 5, 3, 1] 
 
 #Sorts the list in descending order 
 a.sort(reverse=True) 
 
 print a # prints [5, 4, 3, 2, 1] 
```

Если вы хотите отсортировать список на основе собственной функции, используйте параметр **ключа** . Ниже приведен пример сортировки строк в списке по длине, в порядке возрастания

```py
a = ["hello", "hi", "hey"] 
 
 #The built-in len() function is given as an input to key parameter to sort the strings by length 
 a.sort(key = len) 
 
 print a # prints ['hi', 'hey', 'hello'] 
```

Вот еще один пример, в котором список содержит кортежи (имя, возраст). Ниже показано, как сортировать список по возрасту в порядке возрастания.

```py
#Consider the second element in the tuple for sorting 
 >>> def compareByAge(element): 
 ...     return element[1] 
 
 b = [('Adam', 20), ('Rahman', 30), ('Rahul', 25)] 
 
 #Sort the list by age 
 b.sort(key = compareByAge) 
 
 #Output 
 print b # prints [('Adam', 20), ('Rahul', 25), ('Rahman', 30)] 
```

### Основы сортировки

Простое восходящее сортирование очень просто - просто вызовите функцию sorted (). Он возвращает новый отсортированный список:

```python
>>> sorted([5, 2, 3, 1, 4]) 
 [1, 2, 3, 4, 5] 
```

Вы также можете использовать метод list.sort () списка. Он изменяет список на месте (и возвращает None, чтобы избежать путаницы). Обычно это менее удобно, чем отсортировано (), но если вам не нужен исходный список, он немного эффективнее.

```python
>>> a = [5, 2, 3, 1, 4] 
 >>> a.sort() 
 >>> a 
 [1, 2, 3, 4, 5] 
```

Другое отличие состоит в том, что метод list.sort () определен только для списков. Напротив, функция sorted () принимает любой итерабельный.

```python
>>> sorted({1: 'D', 2: 'B', 3: 'B', 4: 'E', 5: 'A'}) 
 [1, 2, 3, 4, 5] 
```

#### Детали реализации

Если вы хотите узнать подробности о реализации функции сортировки, см. [Здесь](http://svn.python.org/projects/python/trunk/Objects/listsort.txt) алгоритм, временную сложность и т. Д. Вкратце, функция сортировки использует алгоритм TimSort, который, согласно разработчикам Python, представляет собой: -

> адаптивное, стабильное, естественное объединение, скромно называемое timsort (эй, я заработал это ). Он обладает сверхъестественными характеристиками на многих виды частично упорядоченных массивов (требуется меньше, чем lg (N!)), и всего лишь N-1), но так же быстро, как предыдущая высоконадежная модель данных Python гибрид на случайных массивах.

#### sort () Параметры

По умолчанию sort () не требует дополнительных параметров. Однако он имеет два необязательных параметра:

*   reverse - если true, отсортированный список отменяется (или сортируется в порядке убывания)
*   key - функция, которая служит ключом для сравнения сортировки

#### Дополнительная информация:

Более подробную информацию о `sort()` можно найти [здесь](https://docs.python.org/3/library/functions.html#sorted)

Более подробную информацию о sort () и sorted () можно найти [здесь](https://docs.python.org/3.6/tutorial/datastructures.html)

Более подробную информацию о sort () и sorted () можно найти [здесь](https://docs.python.org/3.6/tutorial/datastructures.html) .