---
title: Python Numeric Operations
localeTitle: Числовые операции на Python
---
[Документы Python - числовые операции](https://docs.python.org/3/library/stdtypes.html#numeric-types-int-float-complex)

Python полностью поддерживает смешанную арифметику: когда двоичный арифметический оператор имеет операнды разных числовых типов, операнд с более узким типом расширяется до другого, где целое число уже, чем с плавающей точкой, которое уже, чем сложное. Сравнение между числами смешанного типа использует одно и то же правило. [2\] Конструкторы int (), float () и complex () могут использоваться для создания чисел определенного типа.](https://docs.python.org/3/library/functions.html#abs)

Все числовые типы (кроме сложных) поддерживают следующие операции, отсортированные по возрастающему приоритету (все числовые операции имеют более высокий приоритет, чем операции сравнения):

Операция | Результаты | Примечания | Полная документация  
\----------------- | -------------------------------------------------- ------------------------- | ------ | -------------------------------------------------- ---------------------  
`x + y` | сумма х и у | |  
`x - y` | разность x и y | |  
`x * y` | произведение х и у | |  
`x / y` | частное от x и y | |  
`x // y` | наложенное частное от x и y | (1) |  
`x % y` | остаток от x / y | (2)  
`-x` | x отрицание | |  
`+x` | x без изменений | |  
`abs(x)` | абсолютное значение или величина x | | \[ `abs()`  
`int(x)` | x преобразован в целое число | (3) (6) | [`int()`](https://docs.python.org/3/library/functions.html#int)  
`float(x)` | x преобразован в плавающую точку | (4) (6) | [`float()`](https://docs.python.org/3/library/functions.html#float)  
`complex(re, im)` | комплексное число с вещественной частью re, мнимая часть im. im по умолчанию равен нулю. | (6) | [`complex()`](https://docs.python.org/3/library/functions.html#complex)  
`c.conjugate()` | сопряженное к комплексному числу c | |  
`divmod(x, y)` | пара (x // y, x% y) | (2) | [`divmod()`](https://docs.python.org/3/library/functions.html#divmod)  
`pow(x, y)` | x к мощности y | (5) | [`pow()`](https://docs.python.org/3/library/functions.html#pow)  
`x ** y` | x к мощности y | (5)

**Заметки:**

1.  Также упоминается как целочисленное деление. Результирующее значение представляет собой целое целое число, хотя тип результата не обязательно является int. Результат всегда округляется до минус бесконечности: `1//2` равно `0` , `(-1)//2` равно `-1` , `1//(-2)` `-1` , а `(-1)//(-2)` является `0` .
    
2.  Не для комплексных чисел. Вместо этого конвертируйте в float, используя `abs()` если это необходимо.
    
3.  Преобразование с плавающей запятой в целое число может округлять или обрезать, как в C; см. функции [`math.floor()`](https://docs.python.org/3/library/math.html#math.floor) и [`math.ceil()`](https://docs.python.org/3/library/math.html#math.ceil) для четко определенных преобразований.
    
4.  `float` также принимает строки `“nan”` и `“inf”` с необязательным префиксом `“+”` или `“-”` для Not Number (NaN) и положительной или отрицательной бесконечности.
    
5.  Python определяет `pow(0, 0)` и `0 ** 0` равным `1` , что является общим для языков программирования.
    
6.  Числовые литералы, принятые, включают цифры от 0 до 9 или любой эквивалент Unicode (кодовые точки с свойством `Nd` ).
    

> См. [Unicode Derived Numeric Type](http://www.unicode.org/Public/8.0.0/ucd/extracted/DerivedNumericType.txt) для получения полного списка кодовых точек с свойством `Nd` .