---
title: Python 2 vs Python 3
localeTitle: Python 2 против Python 3
---
Мы не принимаем участие в дебатах. Если вам интересно узнать больше об этом в академических целях, возможно, [эта статья, сравнивающая Python 2 и Python 3,](https://wiki.python.org/moin/Python2orPython3) может вас заинтриговать.

Но мы также не можем не знать, что есть два основных аромата Python. Почему ты беспокоишься, спросите вы? Поскольку код, написанный для одной версии Python, может привести к синтаксической ошибке в другой версии Python.

Ниже приведен допустимый оператор `print` в Python 2, но он не работает на Python 3:

```py
print "Hello World" 
```

В Python 3 тот же оператор выдает такую ​​ошибку:
```
>>> print "hello" 
  File "<stdin>", line 1 
    print "hello" 
                ^ 
 SyntaxError: Missing parentheses in call to 'print' 
```

В Python 2 «print» рассматривается как оператор, а не как функция. В скобках нет необходимости обертывать текст, который вы хотите распечатать, хотя вы можете, если хотите. Python 3 явно рассматривает «print» как функцию, что означает, что вы должны передавать элементы, которые вам нужно распечатать, в функцию в круглых скобках стандартным образом, или вы получите синтаксическую ошибку

Использование функции `print()` является «безопасным» как в Python 2, так и 3:

```python
print("Hello World") 
```

Еще одна разница между Python 2 и Python 3 заключается в том, какую структуру данных они возвращают, когда вы вызываете функцию `map()` .

В Python 2 `map()` возвращает список:
```
>>> result = map(int,['10','20','30','40']) 
 >>> print result 
 >>> [10,20,30,40] 
```

В Python 3 `map()` возвращает итератор:
```
>>> result = map(int,['10','20','30','40']) 
 >>> print (result) 
 >>> <map object at 0x7f40896b4630> 
```

Чтобы получить список в Python 3, вам необходимо его преобразовать:
```
>>> result = list(map(int,['10','20','30','40'])) 
 >>> print (result) 
 >>> [10,20,30,40] 
```

Итак, единственный вопрос, которого вам нужно сейчас коснуться; какой из них вы должны выбрать? Если вы новичок в Python, вы должны выбрать Python 3. Python 2 в настоящее время имеет дату [окончания жизни,](https://www.python.org/dev/peps/pep-0373/#update) установленную в 2020 году. Значение регулярных исправлений не гарантируется в будущем, и да, требуется время, чтобы даже ознакомиться с наиболее распространенными аспектами с помощью Python; и ваше время важно. Итак, инвестируйте свое время и усилия с умом!

Хотя Python 2 хорошо поддерживается и популярен, большинство распространенных библиотек и фреймворков в Python предпочитают Python 3. Django официально [рекомендует](https://docs.djangoproject.com/en/1.9/faq/install/#faq-python-version-support) Python 3. Flask и все его зависимости также [поддерживаются](http://flask.pocoo.org/docs/0.10/python3/#python3-support) на Python 3.

Оба Python 2 и Python 3 великолепны. Большинство дистрибутивов Linux и macOS поставляются с предустановленной Python 2 в качестве стандартной версии Python. И Python 3 родился из ненасытного поиска более читаемых и более красивых языковых конструкций.

В этой статье используется Python 3 для настройки веб-фреймворков в вашей среде разработки. Но перед этим вам нужно убедиться, что у вас есть Python 3 и Вы знаете, как его использовать!

#### Дополнительная информация:

*   [Статьи Python 2 или 3](https://wiki.python.org/moin/Python2orPython3)
