---
title: Coding standards
localeTitle: Стандарты кодирования
---
### Контур

*   Почему стандарты кодирования?
*   Введение в PEP 8
*   команды

### Почему стандарты кодирования?

Глобальное сообщество python быстро растет, и почти каждый использует python. Здесь важна читаемость кода и единообразных стандартов. Любой человек на планете должен уметь читать ваш код и понимать, что он делает. Существует много аспектов понимания кода другого пользователя, например комментарии о том, что делает функция, логическое разделение задач между модулями и функциями, хорошие имена переменных и т. Д.

### Введение в PEP 8

Мы любим придерживаться конвенций. Сообщество пользователей python разработало набор стандартов, которые теперь принимаются как конвенции. Любой код уровня отрасли, который вы пишете, запускается через контрольную панель PEP 8. Поэтому хорошей практикой является начало написания docstrings для ваших классов и функций и переименование переменных в нижнем регистре с соответствующими символами подчеркивания. Возможно, стоит взглянуть на эти стандарты, прежде чем начинать кодирование.

[Вот исчерпывающая ссылка](https://www.python.org/dev/peps/pep-0008/ "Стандарты PEP 8")

### команды

Вот как вы проверяете, соответствует ли ваш код Python его стандартам.

```console
:~$ pip install pep8 
 :~$ pep8 --first myCode.py 
```

Это даст все те строки, которые нарушают стандарты, а также краткое описание исправлений.