---
title: Python f-strings
localeTitle: Python f-strings
---
# f-строки в Python

В версии Python 3.6 был реализован новый метод форматирования строк. Новый метод называется интерполяцией строк Literal (хотя обычно называется f-строкой).

Использование f-строки позволяет программисту динамически вставлять переменную в строку в чистом и сжатом виде. В дополнение к вставке переменных в строку эта функция также предоставляет возможность программисту оценивать выражения, присоединяться к содержимому коллекции и даже вызывать функции внутри f-строки.

Чтобы выполнить эти динамические поведения внутри f-строки, мы обертываем их внутри фигурных скобок внутри строки и добавляем нижний регистр f к началу строки (перед открывающей цитатой.

### Примеры

1.  Динамическая вставка переменной в строку во время выполнения:
    
    ```python
    name = 'Jon Snow' 
     greeting = f'Hello! {name}' 
     print(greeting) 
    
    ```
    
2.  Вычислить выражение в строке: `python val1 = 2 val2 = 3 expr = f'The sum of {val1} + {val2} is {val1 + val2}' print(expr)`
    
3.  Вызов функции и вставка вывода в строку:
    
    ```python
    def sum(*args): 
        result = 0 
        for arg in args: 
            result += arg 
        return result 
     
     func = f'The sum of 3 + 5 is {sum(3, 5)}' 
     print(func) 
    
    ```
    
4.  Объединение содержимого коллекции в строку:
    
    ```python
    fruits = ['Apple', 'Banana', 'Pear'] 
     
     list_str = f'List of fruits: {", ".join(fruits)}' 
     print(list_str) 
    
    ```
    

### источники

https://www.python.org/dev/peps/pep-0498/