---
title: Python Sequence Types
localeTitle: Типы последовательности Python
---
Они представляют собой конечные упорядоченные множества, индексированные неотрицательными числами. Встроенная функция `len()` возвращает количество элементов последовательности. Когда длина последовательности равна `n` , набор индексов содержит числа `0, 1, ..., n-1` . Пункт `i` последовательности a выбирается с `a<a href='https://docs.python.org/3/reference/datamodel.html#the-standard-type-hierarchy' target='_blank' rel='nofollow'>i]` .

\[Документы Python - иерархия стандартного типа

## Больше

*   Типы встроенных последовательностей:
    
    *   `list`
        
    *   `tuple`
        
    *   `range`
        
*   Встроенные типы последовательностей являются итерируемыми типами (требуется реализовать `__iter__()` ).
    
*   Операции:
    
    *   [Общие операции последовательности](https://docs.python.org/3/library/stdtypes.html#common-sequence-operations)
        
    *   [Типы управляемых последовательностей](https://docs.python.org/3/library/stdtypes.html#mutable-sequence-types)
        
    *   [Неизменяемые типы последовательностей](https://docs.python.org/3/library/stdtypes.html#immutable-sequence-types)