---
title: Setting Up Python Web Framework Django and Flask
localeTitle: Настройка Python Web Framework Django и Flask
---
В этой статье мы обсудим, как установить [Django](https://www.djangoproject.com/) и [Flask](http://flask.pocoo.org/) - две популярные веб-фреймворки, написанные на Python.

Возможно, вы уже знакомы с широким использованием и поддержкой сообщества для Python; в веб-разработке. Вы также можете знать, что такое веб-инфраструктура; и параметры, доступные для Python.

Если эти допущения неверны, вы можете взглянуть на эту статью в вики . Если вы все пойманы, давайте пойдем ахед с настройкой веб-фреймворков Python на вашей локальной машине разработки.

Но было бы несправедливо, если бы мы полностью игнорировали споры [Python 2 и Python 3](http://docs.python-guide.org/en/latest/starting/which-python/#the-state-of-python-2-vs-3) .

## Виртуальная среда

Перед тем, как мы установим Django, мы предложим вам установить чрезвычайно полезный инструмент, который поможет сохранить вашу среду кодирования на вашем компьютере. Пропустить этот шаг можно, но это настоятельно рекомендуется. Начиная с наилучшей настройки, вы сэкономите массу неприятностей в будущем!

Итак, давайте создадим виртуальную среду (также называемую virtualenv). Virtualenv будет изолировать вашу настройку Python / Django для каждого проекта. Это означает, что любые изменения, внесенные вами на один веб-сайт, не будут влиять на других, которые вы также разрабатываете. Неплохо, да?

Для получения дополнительной информации о виртуальных средах смотрите раздел Релевента [здесь](https://guide.freecodecamp.org/python/virtual-environments/) .

## Завершение

Если вы уже установили `pip` просто:
```
$ pip install django 
```

После завершения установки мы можем создать новый проект:
```
$ django-admin startproject myproject 
 $ cd myproject 
 $ python manage.py runserver 
```

Перейдите по `http://localhost:8000` ! : Ракета:

Мы успешно установили веб-структуру нашей потребности. Однако он еще не завершен. Большинство веб-приложений - это контент и данные, поэтому нам нужно хранить данные. Или База данных, если хотите.

В следующей статье мы обсудим, как установить PostgreSQL и использовать его в нашем веб-приложении Python.

Точка для размышлений - мы использовали `pip` сильно, но мы почти ничего не сказали об этом. Ну, на данный момент это просто менеджер пакетов, например, `npm` . Он имеет некоторые отличия от `npm` ; но теперь вам не нужно беспокоиться об этом. Если вы заинтересованы, не проверить [официальную `pip` документации](http://pip-python3.readthedocs.org/en/latest/index.html) .

_Если у вас есть предложения или вопросы, присоединяйтесь к нам на [gitter](https://gitter.im/FreeCodeCamp/FreeCodeCamp)_ .