---
title: Python Slicestartstopstep
localeTitle: Python Slicestartstopstep
---
`slice(start:stop[:step])` - это объект, обычно содержащий часть последовательности. Слайс создается с использованием индексной нотации, \[\] с двоеточиями между числами, когда дано несколько, например, в переменной\_имя \[1: 3: 5\].

## аргументы

Эта функция может использоваться для среза кортежей, массивов и списков.

Значение параметра `start` (или None, если не указано)

Значение параметра `stop` (или последнего индекса последовательности)

Значение параметра `step` (или None, если не указано). Это не может быть 0.

Все три должны быть целочисленного типа.

## Вернуть

Если предусмотрен только `stop` , он генерирует часть последовательности от индекса `0` до `stop` .

Если предусмотрен только `start` , он генерирует часть последовательности после `start` индекса до последнего элемента.

Если предусмотрены обе `start` и `stop` , он генерирует часть последовательности после `start` индекса до `stop` .

Если все три `start` , `stop` и `step` предусмотрен, он генерирует часть последовательности после индекса `start` до `stop` с приростом индекса `step` .

## пример
```
a = [1, 2, 3, 4, 5, 6, 7, 8] 
 print(a[:5])    # prints [1, 2, 3, 4, 5] 
 print(a[2:])    # prints [3, 4, 5, 6, 7, 8] 
 print(a[2:5])    # prints [3, 4, 5] 
 print(a[2:7:2])    # prints [3, 5, 7] 
```

Вы можете индексировать последний индекс последовательности, используя `-1` :
```
a = [1, 2, 3, 4, 5, 6] 
 print(a[-1])    # prints 6 
 print(a[2:-1])    # prints [3, 4, 5] 
```

Вы можете перевернуть последовательность, используя ноту среза `[::-1]` :
```
a = [1, 2, 3, 4, 5, 6] 
 print(a[::-1])    # prints [6, 5, 4, 3, 2, 1] 
```

[Официальная документация](https://docs.python.org/3/library/functions.html#slice) ![:rocket:](//forum.freecodecamp.com/images/emoji/emoji_one/rocket.png?v=2 ": Ракета:") [Код запуска](https://repl.it/CT5h)