---
title: String Strip Method
localeTitle: Метод строковой полосы
---
## Метод строковой полосы

Существует три варианта удаления символов из строки в Python, `lstrip()` , `rstrip()` и `strip()` .

Каждый из них вернет копию строки с удаленными символами, начиная с начала, с конца или с начала и до конца. Если аргументы не заданы, значение по умолчанию - это пробельные символы.

Пример:

```py
>>> string = '   Hello, World!    ' 
 >>> strip_beginning = string.lstrip() 
 >>> strip_beginning 
 'Hello, World!    ' 
 >>> strip_end = string.rstrip() 
 >>> strip_end 
 '   Hello, World!' 
 >>> strip_both = string.strip() 
 >>> strip_both 
 'Hello, World!' 
```

Необязательный аргумент может быть предоставлен в виде строки, содержащей все символы, которые вы хотите удалить.

```py
>>> url = 'www.example.com/' 
 >>> url.strip('w./') 
 'example.com' 
```

Однако заметьте, что только первый `.` лишился из строки. Это связано с тем, что функция `strip` пропускает только символы аргументов, которые лежат слева или справа. Так как w приходит до первого `.` их объединяют, тогда как «com» ​​присутствует в правом конце до `.` после удаления `/`

#### Дополнительная информация:

[Документация по](https://docs.python.org/3/library/stdtypes.html#string-methods) строковым методам.