---
title: Python Ternary Operater
localeTitle: Терминальный оператор Python
---
# Тернарный оператор в Python

Тернарные операции в Python, часто называемые условными выражениями, позволяют программисту выполнять оценку и возвращать значение, основанное на истине данного условия.

Тернарный оператор отличается от стандартной `if` , `else` , структурой `elif` в том смысле, что он не является структурой потока управления и ведет себя как другие операторы, такие как `==` или `!=` На языке Python.

### пример

В этом примере строка `Even` возвращается, если переменная `val` является четной, в противном случае возвращается строка `Odd` . `is_even` строка затем присваивается переменной `is_even` и печатается на консоли.

#### вход

```python
for val in range(1, 11): 
    is_even = "Even" if val % 2 == 0 else "Odd" 
    print(val, is_even, sep=' = ') 
```

#### Вывод
```
1 = Odd 
 2 = Even 
 3 = Odd 
 4 = Even 
 5 = Odd 
 6 = Even 
 7 = Odd 
 8 = Even 
 9 = Odd 
 10 = Even 
```

### источники

https://docs.python.org/2.5/whatsnew/pep-308.html