---
title: Python Variables Names and Binding
localeTitle: Переменные имен Python и привязка
---
Наличие _объектов_ не полезно, если только не существует способа их использования. Чтобы использовать _объект_ , должен быть способ ссылки на них. В Python это делается путем **привязки** объектов к **именам** . Подробный обзор можно найти [здесь](https://docs.python.org/3/reference/executionmodel.html)

Один из способов сделать это - использовать оператор [_присваивания_](https://docs.python.org/3/reference/simple_stmts.html#assignment-statements) . Обычно это называется _назначением переменной_ в контексте Python. Если говорить о программировании в контексте других языков, **привязка** _объекта_ к **имени** может быть более точной.
```
>>> some_number = 1 
 >>> print(some_number) 
 1 
```

В приведенном выше примере целью оператора присваивания является имя (идентификатор), `some_number` . _Объектом_ , назначаемым, является номер 1. Оператор **привязывает** _объект_ к **имени** . Второй оператор, мы используем эту привязку для `print` _объекта_ , к `some_number` относится `some_number` .

Идентификатор не предшествует _типу_ . Это потому, что Python - это язык с динамическим вводом. Идентификатор привязан к _объекту_ , который имеет _тип_ , однако сам идентификатор можно отскочить к другому _объекту_ другого _типа_ :
```
>>> some_variable = 1 
 >>> print(some_variable) 
 1 
 >>> some_variable = "Hello campers!" 
 >>> print(some_variable) 
 Hello campers! 
```

При переименовании переменных вы должны соблюдать следующие правила:

*   Имя переменной должно начинаться с буквы или символа подчеркивания
*   Имя переменной не может начинаться с числа или специальных символов (! @ #% ^ & \* И т. Д.).
*   Имя переменной может содержать только буквенно-цифровые символы и символы подчеркивания (Az, 0-9 и \_)
*   Имена переменных зависят от регистра (num, NUM и Num - три разные переменные)