---
title: Bottle
localeTitle: бутылка
---
Рамка для бутылок позволяет нам очень быстро и легко вставать и работать с помощью базового веб-приложения.

Ниже приведена информация о том, как писать и запускать простое приветственное веб-приложение, в котором мы можем ввести наше имя в форме, нажмите «Отправить» и верните приветствие.

1.  Используйте `pip` для установки пакета бутылок.
    
    ```
    pip install bottle 
    
    ```
    
2.  Создайте файл `html` который будет использоваться при загрузке сайта. Например `index.html` .
    
    Давайте добавим заголовок и базовую форму на эту страницу.
    
    ```html
    
    <h3>Say Hello</h3> 
     
     <form action="/hello" method="get"> 
     Name: 
        <input type="text" name="name"><br><br> 
        <input type="submit"> 
     </form> 
    
    ```
    
3.  Создайте новый файл python, например `main.py`
    
4.  В первой строке файла нам нужно импортировать функции получения, запроса и запуска из модуля бутылки.
    
    ```python
    from bottle import get, request, run 
    
    ```
    
5.  Теперь мы определяем нашу функцию для обслуживания нашего html-файла при обращении к корневой странице.
    
    Здесь мы используем декоратор `@get` , который указывает, что эта функция должна отвечать на `HTTP GET` запросы `HTTP GET` и передавать в `'/'` в качестве пути, к которому будет вызвана функция.
    
    Затем мы определяем функцию `index()` с использованием ключевого слова `def` .
    
    Чтобы прочитать и вернуть html-файл, который мы создали на шаге 2, мы используем так называемый менеджер контекста. Это позволяет открывать и закрывать файл для нас, позволяя нам читать файлы и содержимое и возвращать их с помощью оператора `return` .
    
    ```python
    @get('/') 
     def index(): 
        with open('./index.html') as f: 
            return f.read() 
    
    ```
    
6.  Чтобы заставить сайт запускать и прослушивать запросы, нам нужно добавить вызов функции `run` фреймворка бутылки следующим образом.
    
    Здесь мы передаем хост, на котором будет работать веб-приложение, в данном случае - `localhost` , и порт, который он должен прослушивать для HTTP-запросов.
    
7.  Запустите приложение и загрузите его в своем браузере. Http: // localhost: 8080 /, вы должны увидеть html-файл, который мы создали в браузере.
    
    Если мы введем наше имя и нажимаем submit, мы получим ошибку `HTTP 404` хотя мы еще не определили функцию для ответа на этот запрос.
    
    ```python
    run(host='localhost', port=8080) 
    
    ```
    
8.  Вернемся в наш файл `main.py` и теперь нам нужно определить функцию, которая будет отвечать, когда вы будете удалять нашу форму.
    
    Опять же, здесь используется декоратор `@get` , но на этот раз мы переходим в `'/.hello'` в качестве пути. Вы можете заметить, что это тот же путь, который мы определили в атрибуте action нашей формы в `index.html` .
    
    Затем мы извлекаем значение `name` из url, при отправке формы данные формы кодируются url следующим образом http: // localhost: 8080 / hello? Name = Jon + Snow
    
    Наконец, мы возвращаем приветствие, добавляя имя, введенное в нашу форму.
    
    ```python
    @get('/hello') 
     def hello(): 
        name = request.query['name'] 
        return f'Hello {name}' 
    
    ```
    

### источники

https://bottlepy.org/docs/dev/