---
title: Python Web Frameworks and What They Do 
localeTitle: Веб-платформы Python и что они делают
---
Мы использовали слово `framework` довольно либерально в предыдущих статьях. Вы можете или не знать, что это такое. Тем не менее, мы обсудим, какие Python Web Framework делают для вас, из коробки.

Веб-структуры, если говорить неформально, сделают для вас то, что будет делать _многократно,_ если вы собираетесь создавать множество веб-сайтов с различными функциональными возможностями.

Давайте рассмотрим чрезвычайно грубый пример и попытаемся сделать простую аналогию. Скажите, вы идете на обед, и это причудливый ресторан. Это может быть любой ресторан - итальянский, мексиканский, индийский, корейский, пан-азиатский.

Постарайтесь подумать об общих вещах, которые происходят в ресторане, когда клиент входит. Кавалер может взять ваш автомобиль и проверить парковку. Вас могут попросить на стойке регистрации, если вы бронировали; и сколько ваших друзей с вами. Вас, вероятно, покажут на вашем столе или попросят подождать - в зависимости от толпы внутри.

После посадки вас спросят, хотите ли вы обычную или бутилированную воду. Тогда кто-то спросит, предпочитаете ли вы напитки. Вы можете заказать несколько стартеров, а затем основной курс; и, наконец, какой-то десерт. Вы должны оплатить счет.

Я понимаю, если вы хотите сделать минутку, чтобы совершить поездку по переулку памяти, наслаждаясь восхитительным зумом. Как только вы закончите, вам нужно поставить себя в положение лица, управляющего бизнесом.

Если вы заметили, есть некоторые действия, которые вы делаете повторно для каждого клиента. И в зависимости от типа ресторана и времени дня, есть некоторые вещи, которые будут отличаться. Например, меню и цены на продукты питания.

Скажем, вы управляете бизнесом; вам также необходимо будет обрабатывать другие аспекты этого бизнеса, о которых клиент не обращает внимания. Например; зарплата персонала, управление книгами, оплата аренды и налог на имущество, печать новых карточек меню и т. д.

Вам интересно, куда ведет этот разговор. Успокойся! Мы возвращаемся к веб-разработке Python как можно скорее.

Веб-Framework выполняет эти повторяющиеся действия для вас - что вы будете делать, когда создаете веб-приложение, используя только язык программирования и некоторые сетевые библиотеки. Как обработка запросов, маршрутизация URL-адресов, компиляция шаблонов, настройка контекста, защита CSRF, ведение журнала, взаимодействие с базами данных через ORM, аутентификация, рендеринг ответов и т. Д.

Вы, вероятно, задаетесь вопросом, что же остается за разработчиком? На основе приложения вы должны использовать API-интерфейсы и написать свою прикладную логику.

Ваш код заполнит пробелы, _умышленно_ оставленные в коде фреймворка, и объединив ваш код с каркасом; ваше веб-приложение вдохнет в него жизнь!

Двумя из самых популярных веб-фреймворков в Python являются Django и Flask. Django - это, вероятно, самая используемая инфраструктура Python. Django помогает создавать сайты, на которых вы взаимодействуете как с клиентом (пользователем), так и с вашей базой данных, часто одновременно. Flask - это микро-каркас, который также может выполнять многие задачи, которые делает Django, но используя расширения, созданные сообществом. Другими ценностями, которые стоит упомянуть, являются «Пилоны» и «Торнадо».

### Джанго

Django (/ dʒæŋɡoʊ / JANG-goh) - это бесплатный веб-фреймворк с открытым исходным кодом, написанный на Python, который следует за архитектурным шаблоном модели-шаблона (MVT). Он поддерживается Django Software Foundation (DSF), независимой организацией, созданной как некоммерческая организация 501 (c) (3).

Основная цель Django - облегчить создание сложных веб-сайтов, основанных на базе данных. Джанго подчеркивает возможность повторного использования и «зависания» компонентов, быстрое развитие и принцип не повторяться. Python используется повсеместно, даже для файлов настроек и моделей данных. Django также предоставляет дополнительный административный интерфейс создания, чтения, обновления и удаления, который генерируется динамически через интроспекцию и настраивается с помощью модов администратора.

Некоторые известные сайты, использующие Django, включают Службу общественного вещания, Instagram, Mozilla, The Washington Times, Disqus, Bitbucket и Nextdoor. Он использовался на Pinterest, но позже сайт переместился в фреймворк, построенный над Flask.

### колба

Flask - это легкое веб-приложение WSGI и микро-каркас, который он классифицируется как микрокарт, потому что он не требует определенных инструментов или библиотек. Он предназначен для быстрого и легкого запуска, с возможностью масштабирования до сложных приложений. Тем не менее Flask поддерживает расширения, которые могут добавлять функции приложения, как если бы они были реализованы в самой Flask. Расширения существуют для объектно-реляционных картографов, проверки формы, обработки загрузки, различных технологий открытой аутентификации и нескольких общих инструментов, связанных с картой. Расширения обновляются гораздо чаще, чем основная программа Flask. Фланец обычно используется с MongoDB (NOSQL DataBase), который позволяет ему больше контролировать базы данных и историю.

Он начался как простая обертка вокруг Werkzeug и Jinja и стал одной из самых популярных фреймворков веб-приложений Python.

Flask предлагает предложения, но не обеспечивает каких-либо зависимостей или макета проекта. Разработчик должен выбрать инструменты и библиотеки, которые они хотят использовать. Сообщество предлагает множество расширений, которые упрощают добавление новых функций.

Фляга была сделана в 2004 году международной группой питонистов под названием «Pocoo», как шутка от первого дурака, которая позже превратилась в «реальную» вещь. Согласно Wikpedia, это была самая используемая веб-инфраструктура Python на GitHub. Это бесплатная и открытая микроархитектура, написанная на Python ( [просмотр GitHub](https://github.com/freeCodeCamp/guide/tree/master/src/pages/javascript) ). Как утверждает Википедия,

Колба классифицируется как микрокарта, потому что она не требует специальных инструментов или библиотек. Он не имеет уровня абстракции базы данных, проверки формы или любых других компонентов, в которых уже существующие сторонние библиотеки предоставляют общие функции.

Фланец - это очень «карманы без батарей», по сравнению с чем-то вроде Django. Это означает, что вам необходимо установить модули, такие как аутентификация пользователя, формы и другие вещи самостоятельно. Нельзя сказать, что Flask не создан для этих вещей, просто потому, что они не включены, и эти модули создаются сообществом. Flask также содержит обширную подробную документацию, доступную по адресу http://flask.pocoo.org/docs/. Он обеспечивает простоту и больший контроль над меньшими вещами. У вас не будет функциональности, которая не используется, так как вы можете выбрать то, что добавлено, а что нет.

Сайты, в которых используется Flask, включают Pinterest! (который перешел из Django), частный API Twilio (они даже сделали расширение под названием Flask-RESTful для API) и Netflix (который использует ScriptFlask, инструмент на основе Flask)

### бутылка

Бутылка - это микроформат Python, который позволяет пользователям быстро запускаться и запускаться с помощью веб-приложения Python. Это намного легче, чем что-то более полно, например Django, и не имеет сторонних зависимостей, полагающихся только на стандартную библиотеку Python.

Это делает его идеальным для небольших веб-приложений, где некоторые из более сложных функций Django, таких как аутентификация или доступ к базе данных, не требуются.
