---
title: While Loop Statements
localeTitle: В то время как записи цикла
---
## В то время как записи цикла

Python использует `while` цикл так же , как другие популярные языки. В `while` цикл вычисляет условие затем выполняет блок кода , если условие истинно. Блок кода выполняется повторно до тех пор, пока условие не станет ложным.

Основной синтаксис:

```python
counter = 0 
 while counter < 10: 
   # Execute the block of code here as 
   # long as counter is less than 10 
```

Пример показан ниже:

```python
days = 0 
 week = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'] 
 while days < 7: 
   print("Today is " + week[days]) 
   days += 1 
```

Вывод:
```
Today is Monday 
 Today is Tuesday 
 Today is Wednesday 
 Today is Thursday 
 Today is Friday 
 Today is Saturday 
 Today is Sunday 
```

Поэтапное объяснение приведенного выше КОДА:

1.  переменная 'days' устанавливается в значение 0.
2.  переменная неделя назначается списку, содержащему все дни недели.
3.  при запуске цикла
4.  блок кода будет выполняться до тех пор, пока условие не вернет «true».
5.  условие - это «дни <7», которые, по-видимому, повторяют цикл while до момента, когда переменные дни меньше 7
6.  Поэтому, когда дни = 7, цикл while прекращает выполнение.
7.  переменная дней обновляется на каждой итерации.
8.  Когда цикл while запускается в первый раз, строка «Сегодня понедельник» печатается на консоли, а переменные дни становятся равными 1.
9.  Поскольку переменные дни равны 1, что меньше 7, тогда цикл while выполняется снова.
10.  Он повторяется снова и снова, и когда консоль печатает «Сегодня воскресенье», переменные дни теперь равны 7, а цикл while прекращает выполнение.

#### Дополнительная информация:

*   [Документация оператора Python `while`](https://docs.python.org/3/reference/compound_stmts.html#the-while-statement)