---
title: Data Types in R
localeTitle: Типы данных в R
--- ## Скаляры

Скаляр относится к атомной величине, которая может удерживать только одно значение за раз. Скалары - это самые основные типы данных. Некоторые распространенные типы скаляров:

1.  Число
    
    > x <- 5 y <- 5,5 класс (х) \[1\] "числовые" класс (у) \[1\] "числовые" класс (х + у) \[1\] "числовые"
    
2.  Логическое значение
    
    > m <- x> y # Используется для проверки, Is x больше y? n <- x <y # Используется для проверки, Is x меньше y? м \[1\] ЛОЖЬ N \[1\] ИСТИНА класс (м) \[1\] "логический" class (NA) # NA - другое логическое значение: «Недоступно» / «Отсутствующие значения» \[1\] "логический"
    
3.  Символ (строка)
    
    > a <- "1"; b <- "2,5" а; \[1\] "1" \[1\] "2,5" а + б Ошибка в a + b: нечисловой аргумент двоичному оператору класс (а) \[1\] "персонаж" класс (as.numeric (а)) \[1\] "числовые" класс (as.character (х)) \[1\] "персонаж"
    

## Вектор

Это последовательность элементов данных одного и того же базового типа. Например:
```
> o <- c(1,2,5.3,6,-2,4)                                 # Numeric vector 
 > p <- c("one","two","three","four","five","six")        # Character vector 
 > q <- c(TRUE,TRUE,FALSE,TRUE,FALSE,TRUE)                # Logical vector 
 > o;p;q 
 [1]  1.0  2.0  5.3  6.0 -2.0  4.0 
 [1] "one"   "two"   "three" "four"  "five"  "six" 
 [1]  TRUE  TRUE FALSE  TRUE FALSE 
```

## матрица

Это двумерный прямоугольный набор данных. Компоненты в матрице также должны быть одного и того же базового типа, такого как вектор. Например:
```
> m = matrix( c('a','a','b','c','b','a'), nrow = 2, ncol = 3, byrow = TRUE) 
 > m 
 >[,1] [,2] [,3] 
 [1,] "a"  "a"  "b" 
 [2,] "c"  "b"  "a" 
```

## Кадр данных

Он более общий, чем матрица, поскольку разные столбцы могут иметь разные базовые типы данных. Например:
```
> d <- c(1,2,3,4) 
 > e <- c("red", "white", "red", NA) 
 > f <- c(TRUE,TRUE,TRUE,FALSE) 
 > mydata <- data.frame(d,e,f) 
 > names(mydata) <- c("ID","Color","Passed") 
 > mydata 
 
   ID Color Passed 
 1  1   red   TRUE 
 2  2 white   TRUE 
 3  3   red   TRUE 
 4  4  <NA>  FALSE 
```

## Списки

Это R-объект, который может содержать в себе множество различных типов элементов, таких как векторы, функции и даже другой список внутри него. Например:
```
> list1 <- list(c(2,5,3),21.3,sin) 
 > list1 
 [[1]] 
 [1] 2 5 3 
 [[2]] 
 [1] 21.3 
 [[3]] 
 function (x)  .Primitive("sin") 
```

## Справка:

[Официальные документы](https://cran.r-project.org/manuals.html) [Типы данных в R r-bloggers](https://www.r-bloggers.com/classes-and-objects-in-r/)