---
title: Functions in R
localeTitle: Функции в R
---
Функция позволяет вам определить многоразовый блок кода, который может выполняться многократно в вашей программе.

Функции могут быть названы и вызываться повторно или могут выполняться анонимно на месте (аналогично лямбда-функциям в python).

Для полного понимания функций R требуется понимание среды. Среды - это просто способ управления объектами. Примером среды в действии является то, что вы можете использовать избыточную переменную имя внутри функции, которое не будет затронуто, если большая среда выполнения уже имеет одну и ту же переменную. Кроме того, если функция вызывает переменную, не определенную внутри функции, которая будет проверять среду более высокого уровня для этой переменной.

### Синтаксис

В R определение функции имеет следующие функции:

1.  Ключевое слово `function`
2.  имя функции
3.  входные параметры (необязательно)
4.  некоторый блок кода для выполнения
5.  оператор возврата (необязательно)

```{r}
# a function with no parameters or returned values 
 sayHello() = function(){ 
  "Hello!" 
 } 
 
 sayHello()  # calls the function, 'Hello!' is printed to the console 
 
 # a function with a parameter 
 helloWithName = function(name){ 
  paste0("Hello, ", name, "!") 
 } 
 
 helloWithName("Ada")  # calls the function, 'Hello, Ada!' is printed to the console 
 
 # a function with multiple parameters with a return statement 
 multiply = function(val1, val2){ 
  val1 * val2 
 } 
 
 multiply(3, 5)  # prints 15 to the console 
```

Функции - это блоки кода, которые можно повторно использовать, вызывая функцию. Это позволяет простое, элегантное повторное использование кода без явного переписывания разделов кода. Это делает код более читаемым, упрощает отладку и ограничивает ошибки ввода.

Функции в R создаются с использованием ключевого слова `function` вместе с именем функции и параметрами функции в круглых скобках.

Функция `return()` может использоваться функцией для возврата значения и обычно используется для принудительного досрочного завершения функции с возвращаемым значением. В качестве альтернативы, функция вернет окончательное напечатанное значение.

```{r}
# return a value explicitly or simply by printing 
 sum = function(a, b){ 
  c = a + b 
  return(c) 
 } 
 
 sum = function(a, b){ 
  a + b 
 } 
 
 
 result = sum(1, 2) 
 # result = 3 
```

Вы также можете определить значения по умолчанию для параметров, которые R будет использовать, когда переменная не указана во время вызова функции.

```{r}
sum = function(a, b = 3){ 
  a + b 
 } 
 
 result = sum(a = 1) 
 # result = 4 
```

Вы также можете передать параметры в том порядке, который вы хотите, используя имя параметра.

```{r}
result = sum(b=2, a=2) 
 # result = 4 
```

R также может принимать дополнительные необязательные параметры с помощью «...»

```{r}
sum = function(a, b, ...){ 
  a + b + ... 
 } 
 
 sum(1, 2, 3) #returns 6 
```

Функции также могут выполняться анонимно. Они очень полезны в сочетании с семейством функций «apply».

```{r}
# loop through 1, 2, 3 - add 1 to each 
 sapply(1:3, 
       function(i){ 
         i + 1 
         }) 
```

### Заметки

*   Если определение функции включает аргументы без заданных значений по умолчанию, значения этих значений должны быть включены.
    
    ```{r}
    sum = function(a, b = 3){ 
     a + b 
     } 
     
     sum(b = 2) # Error in sum(b = 2) : argument "a" is missing, with no default 
    
    ```
    
*   Переменные, определенные внутри функции, существуют только в пределах этой функции, но будут проверять большую среду, если переменная не указана
    
    ```{r}
    double = function(a){ 
     a * 2 
     } 
     
     double(x)  # Error in double(x) : object 'x' not found 
     
     
     double = function(){ 
     a * 2 
     } 
     
     a = 3 
     double() # 6 
    
    ```
    

## Встроенные функции в R

*   R поставляется со многими функциями, которые вы можете использовать для выполнения сложных задач, таких как случайные выборки.
    
*   Например, вы можете округлить число с помощью `round()` или вычислить его факториал с `factorial()` .
    

```r
> round(4.147) 
 [1] 4 
 > factorial(3) 
 [1] 6 
 > round(mean(1:6)) 
 [1] 4 
```

*   Данные, которые вы передаете в функцию, называются аргументом функции.
    
*   Вы можете моделировать рулон матрицы с помощью функции R `sample()` . Функция `sample()` принимает два аргумента: вектор с именем x и число с именем size. Например:
    

```r
> sample(x = 1:4, size = 2) 
 [] 4 2 
 > sample(x = die, size = 1) 
 [] 3 
 >dice <- sample(die, size = 2, replace = TRUE) 
 >dice 
 [1] 2 4 
 >sum(dice) 
 [1] 6 
```

*   Если вы не знаете, какие имена использовать с функцией, вы можете найти функцию аргументы с аргументами.

```r
> args(round) 
 [1] function(x, digits=0) 
```

## Ресурсы

[Официальные документы](https://cran.r-project.org/manuals.html) [Quick-R](https://www.statmethods.net/management/functions.html) [CRAN](https://cran.r-project.org/doc/manuals/r-release/R-lang.html#Functions) [Расширенные функции R: функции](http://adv-r.had.co.nz/Functions.html)