---
title: Objects in R
localeTitle: Объекты в R
---
## Объекты

R позволяет сохранять данные, сохраняя их внутри объекта R.

## Что такое объект?

Это просто имя, которое вы можете использовать для вызова хранимых данных. Например, вы можете сохранить данные в объект типа a или b.

```r
> a <- 5 
 > a 
 [1] 5 
```

## Как создать объект в R?

1.  Чтобы создать объект R, выберите имя и затем используйте символ меньшего размера, `<` , за которым следует знак минус, `-` , чтобы сохранить данные в нем. Эта комбинация выглядит как стрелка, `<-` . R будет создавать объект, дать ему ваше имя и хранить в нем все следует стрелке.
    
2.  Когда вы спросите R, что находится в a, он сообщает вам следующую строку. Например:
    

```r
> die <- 1:6 
 > die 
 [1] 1 2 3 4 5 6 
```

3.  Вы можете назвать объект в R почти тем, что хотите, но есть несколько правил. Первый, имя не может начинаться с числа. Во-вторых, имя не может использовать некоторые специальные символы, такие как `^, !, $, @, +, -, /, or *` :
    
4.  R также понимает капитализацию (или учитывает регистр), поэтому имя и имя будут относиться к различным объектам.
    
5.  Вы можете узнать, какие имена объектов вы уже использовали с помощью функции `ls()` .
    

## Рекомендации

[Официальные документы](https://cran.r-project.org/manuals.html) [Объекты в R r-bloggers](https://www.r-bloggers.com/classes-and-objects-in-r/) [CRAN](https://cran.r-project.org/doc/manuals/r-release/R-lang.html)