---
title: Functional vs Class Components
localeTitle: Функциональные компоненты класса
---
## React Native - Функциональные компоненты класса

В React Native существуют два основных типа компонентов, которые составляют _функциональные компоненты приложения_ и _компоненты класса_ . Они структурированы так же, как и в обычном приложении React для Интернета.

### Компоненты класса

Компоненты класса - это классы JavaScript ES2015, которые расширяют базовый класс от React, называемого `Component` .

```js
class App extends Component { 
    render () { 
        return ( 
            <Text>Hello World!</Text> 
        ) 
    } 
 } 
```

Это дает классу `App` доступ к жизненным циклам React, таким как `render` а также функции state / props от родителя.

### Функциональные компоненты

Функциональные компоненты проще. Они не управляют своим собственным состоянием или имеют доступ к методам жизненного цикла, предоставленным React Native. Это буквально простые старые функции JavaScript. Они также известны как компоненты без гражданства.

```js
const PageOne = () => { 
    return ( 
        <h1>Page One</h1> 
    ); 
 } 
```

### Резюме

Компоненты класса используются в качестве компонентов контейнера для управления состоянием и переноса дочерних компонентов. Функциональные компоненты обычно используются только для целей отображения - эти компоненты вызывают функции от родительских компонентов для обработки пользовательских взаимодействий или обновлений состояния.