---
title: React Native
localeTitle: React Native
---
## React Native

React Native - это кросс-платформенная платформа для создания мобильных приложений, которые могут работать за пределами браузера - чаще всего приложения для iOS и Android.

Его можно использовать для создания приложений на устройствах Windows, настольных ОС и приложениях Apple TV, но это руководство будет охватывать только самые распространенные цели - приложения для Android и iOS.

**Оглавление**

*   [Что такое React Native?](#what-is-react-native)
*   [Причины выбора React Native](#reasons-to-choose-react-native)
*   [Как начать работу с eact Native](#how-to-get-started-with-react-native)

### Что такое React Native

React Native позволяет входить в состав родных и гибридных приложений в спектре мобильных приложений. Созданный пользовательский интерфейс полностью является родным, а общая производительность приложения почти такая же, как и запись родного приложения. Это также дает вам возможность встраивать веб-представления (веб-страницы) или собственный код (Java / Kotlin для Android, Objective C / Swift для iOS) внутри ваших приложений, где бы вы ни захотели.

Он следует той же схеме, что и React, где представления (то, что вы видите на экране) отображаются из файлов JavaScript. Разница в том, что он предоставляет свой собственный API для обработки собственных мобильных представлений и DOM в Интернете. Если вы смущены тем, как это работает, следуйте этому руководству по freeCodeCamp, и он будет проходить шаг за шагом через эти концепции.

### Причины выбора React Native

1.  **Повторное** использование кода. Он использует один код, который разделяется между обеими платформами.
2.  **Повторное использование веб-инструментов и навыков.** Повторное использование знаний, инструментов и утилит JavaScript, таких как `axios` , Redux и других библиотек, которые не требуют DOM из Интернета.
3.  **Оптимизирован для производительности разработчиков.** Поставляется с такими функциями, как перезагрузка и перезапуск модулей модуля, а также инструменты для создания Chrome для отладки!
4.  **Производительность.** Выполняется лучше, чем гибридные платформы приложений, такие как Ionic и Cordova, поскольку не использует веб-представления.
5.  **Корпоративная поддержка.** Много компаний поддерживают и вносят вклад в React Native, включая Walmart, Airbnb, Wix и, конечно же, Facebook.
6.  **Сообщество** - React Native имеет большое (и растущее) сообщество с более чем 1500 участниками основного проекта и тысячи других, которые вносят вклад в различные библиотеки.
7.  **Лучший пользовательский интерфейс** - React Native использует код JavaScript для рендеринга собственных компонентов из ОС вашего телефона. Другими словами, пользовательский интерфейс приложения (UI) является полностью родным!
8.  **Cross-Platform** - отличный способ прототипа и сэкономить время при создании универсального пользовательского интерфейса или специального приложения для платформы, которое может работать как на устройствах iOS, так и на Android.

### Как начать работу с коренными жителями

React Native - два простых простых способа начать работу. В зависимости от вашей ситуации, вы можете быть лучшим вариантом для вас.

1.  [Создайте приложение React Native](https://www.npmjs.com/package/create-react-native-app) - похожее на приложение Create React, оно запускается с использованием терминала.
2.  [Expo](https://expo.io) - Лучшее для прототипирования приложения или если это более ранняя стадия. Используя Expo, вы даже можете создать быстрое приложение, используя функции перетаскивания из snack.expo.io в broswer.
