---
title: Screen Dimensions
localeTitle: Размеры экрана
---
## React Native - Размер экрана

React Native использует Dots In Inch (DPI) для измерения размера пользовательского интерфейса (UI) и всего, что отображается в пользовательском интерфейсе. Этот тип измерений позволяет приложению выглядеть однородно по различным размерам экрана и плотности пикселей.

В стандартных случаях приложения могут быть разработаны без необходимости знать специфику устройства пользователя (например, плотность пикселей), поскольку элементы пользовательского интерфейса будут масштабироваться автоматически. Когда это требуется, есть API-интерфейсы, такие как `PixelRatio` для определения плотности пикселей пользовательского устройства.

Чтобы получить высоту и ширину окна или экрана пользовательского устройства, React Native имеет API под названием « `Dimensions` .

```js
import { Dimensions } from 'react-native'; 
```

Вот методы, которые предоставляет API-интерфейс `Dimensions` :

```js
Dimensions.get('window').height; 
 Dimensions.get('window').width; 
 Dimensions.get('screen').height; 
 Dimensions.get('screen').width; 
```

**Примечание. В прошлом были некоторые известные проблемы с API-интерфейсом Dimensions, такими как не возвращающая правильную информацию, когда пользователь поворачивает свое устройство. Лучше всего проверять это на реальных устройствах перед развертыванием приложения.**