---
title: React
localeTitle: React
---
# React


React - это библиотека JavaScript для создания пользовательских интерфейсов. Он был признан самым любимым в категории "Frameworks, Libraries, и другие технологии" опроса разработчиков Stack Overflow 2017.<sup>1</sup>


React - это библиотека JavaScript и React приложения, созданные с помощью неё, запускаются в браузере, а НЕ на сервере. Приложения такого рода только взаимодействуют с сервером, когда это необходимо, что делает их очень быстрыми по сравнению с традиционными веб-сайтами, которые заставляют пользователя ждать, пока сервер повторно развернет целые страницы и отправит их в браузер.

React используется для создания пользовательских интерфейсов - то, что пользователь видит на своем экране и взаимодействует с вашим веб-приложением. Этот интерфейс разделяется на компоненты, вместо того, чтобы иметь одну огромную страницу, вы разбиваете ее на более мелкие части, известные как компоненты. В более общих терминах этот подход называется модулярностью.

*   Он декларативный: React использует декларативную парадигму, которая упрощает рассуждение о вашем приложении.
*   Он эффективен: React вычисляет минимальный набор изменений, необходимых для обновления вашего DOM.
*   И это гибко: React работает с библиотеками и фреймворками, которые вы уже знаете.

## Зачем изучать React?


1.  React включает в себя композицию, состоящую из множества компонентов, которые обертывают функциональные возможности в инкапсулированный контейнер. Многие популярные сайты используют React для реализации архитектурного шаблона MVC. Facebook (частично), Instagram (полностью), Академия Khan (частично), Codecademy (частично), New York Times (частично), Yahoo Mail (полностью), новое приложение для фото и видео Dropbox Карусель (полностью) - популярные популярные сайты использовать React. Как эти большие приложения создаются с использованием React? Простой ответ заключается в создании небольших приложений или компонентов. Пример:


```jsx
const Component2 = () => { 
  return ( 
    <div></div> 
  ); 
}; 
const Component3 = () => { 
  return ( 
    <div></div> 
  ); 
}; 
const Component1 = () => { 
  return ( 
    <div> 
      <Component2 /> 
      <Component3 /> 
    </div> 
  ); 
}; 
 
ReactDOM.render( 
  <Component1 />, 
  document.getElementById("app") 
); 
```

2.  React является декларативной для большей части, в которой нас больше интересует «Что делать, а не как выполнять определенную задачу». Декларативное программирование - это парадигма программирования, которая выражает логику вычисления без описания его потока управления. Декларативное программирование имеет определенные преимущества, такие как уменьшенные побочные эффекты (возникает, когда мы модифицируем какое-либо состояние или что-то изменяем или делаем запрос API), сводя к минимуму изменчивость (как много абстрагируется), улучшенная читаемость, меньшие ошибки.
    

3.  Однонаправленный поток данных. UI в React фактически является функцией состояния, которое означает, что состояние обновляет его и обновляет пользовательский интерфейс. Поэтому наш пользовательский интерфейс прогрессирует по мере изменения состояния.

    

## Преимущества React

Некоторые причины использования React:

1.  Быстро. Приложения, созданные в React, могут обрабатывать сложные обновления, но при этом не теряя в отзывчивости.
2.  Modular. Вместо того, чтобы писать большие, плотные файлы кода, вы можете писать много меньших, многоразовых файлов. React модульность может быть красивым решением в JavaScript [проблем ремонтопригодности](https://en.wikipedia.org/wiki/Spaghetti_code) .

3.  Масштабируемость. Большие программы, отображающие много изменяющихся данных, - это где React лучше всего работает.
4.  Гибкое. Вы можете использовать React для интересных проектов, которые не имеют никакого отношения к созданию веб-приложения. Люди все еще понимают потенциал React. [Есть возможность исследовать](https://medium.mybridge.co/22-amazing-open-source-react-projects-cb8230ec719f) .

### Виртуальный DOM

Магия React исходит из его интерпретации DOM и ее стратегии создания пользовательских интерфейсов.

React использует виртуальную DOM, чтобы сначала визуализировать дерево HTML, а затем, каждый раз, когда изменяется состояние, и мы получаем новое дерево HTML, которое нужно взять в DOM браузера, вместо того, чтобы писать все новое дерево. React будет писать только разница между новым деревом и предыдущим деревом (так как у React есть оба дерева в памяти). Этот процесс известен как «Дерево примирения».

### сверка

React имеет интеллектуальный дифференцирующий алгоритм, который он использует для восстановления только в своем узле DOM, который на самом деле нуждается в восстановлении, в то время как он сохраняет все остальное как есть. Этот сложный процесс возможен из-за виртуального DOM React.

Используя виртуальную DOM, React сохраняет последнюю версию DOM в памяти и, когда она имеет новую версию DOM для браузера, эта новая версия DOM также будет в памяти, поэтому React может вычислить разницу между новой и старой версиями,

Затем React предложит браузеру обновить только вычисляемый diff, а не весь узел DOM. Независимо от того, сколько раз мы обновляем наш интерфейс, React берет в браузер только новые «частичные» обновления.

## React с нуля

Хотели бы вы начать изучать основы React, не увязнув в создании среды разработки? Скорее всего, если вы не знакомы с веб-разработкой, то создание среды разработки может заставить вас чувствовать себя немного запуганным, когда вы просто пытаетесь изучить React или просто узнать об React в первый раз.

В этой статье мы рассмотрим, как мы можем начать работу с React, используя только текстовый редактор и браузер, и больше ничего.

[!["Смотреть](http://img.youtube.com/vi/YOUTUBE_VIDEO_ID_HERE/0.jpg)](http://www.youtube.com/watch?feature=player_embedded&v=100pKUE3OPI)

[### 1 - Установить Boiler Plate Code с помощью Emmet

Давайте начнем с шага 1. Начнем с файла в нашем браузере под названием «index.html». Начнем с кода HTML текущего boiler plate. Для быстрого начала я рекомендую использовать Emmet с любым текстовым редактором, который у вас есть, и в первой строке ввода в `html:5` затем нажав клавишу shift, чтобы получить код ниже. Или вы можете продолжить и скопировать и вставить код снизу.

```javascript
html:5 
```

Это приведет к следующему коду:

```javascript
<!DOCTYPE html> 
 <html lang="en"> 
 <head> 
  <meta charset="UTF-8"> 
  <meta name="viewport" content="width=device-width, initial-scale=1.0"> 
  <meta http-equiv="X-UA-Compatible" content="ie=edge"> 
  <title>Document</title> 
 </head> 
 <body> 
 
 </body> 
</html> 
```


Мы можем заполнить заголовок «Пришло время для React!».

Этот контент не будет отображаться на вашей веб-странице. Все, что находится в главном разделе файла HTML, будет метаданных, которые наш браузер будет интерпретировать нашим кодом в разделе тела. Этот заголовок будет отображаться на вкладке для нашей страницы, а не на странице.

### 2 - Получить теги скриптов, чтобы использовать силу библиотек React и Babel


Хорошо, первый элемент первый элемент нашего списка пройден. Давайте рассмотрим второй пункт. Мы собираемся настроить среду разработки, используя теги скриптов, чтобы включить React и Babel. Это не настоящая среда разработки. Это будет довольно сложная установка. Это также оставило бы нас с большим количеством кодовых табличек и библиотек, которые отвлекут нас от изучения основ React. Цель этой серии - перейти к основному синтаксису React и получить возможность программировать. Мы будем использовать теги `<script>`, чтобы принести библиотеку React, библиотеку React DOM (почему) и библиотеку Babel.

```javascript
<head> 
  ... 
  <!-- REACT LIBRARY --> 
  <script src="https://unpkg.com/react@15.5.4/dist/react.js"></script> 
  <!-- REACT DOM LIBRARY --> 
  <script src="https://unpkg.com/react-dom@15.5.4/dist/react-dom.js"></script> 
  <!-- BABEL LIBRARY --> 
  <script src="https://cdnjs.cloudflare.com/ajax/libs/babel-standalone/6.25.0/babel.min.js"></script> 
  ... 
  <title>Time to React!</title> 
</head> 
```

Вы можете использовать более обновленные версии этих библиотек по мере их выхода. Они не должны создавать никаких изменений для контента, который мы рассматриваем.


Что мы тут делаем? Элемент: HTML `<script>` используется для встраивания или ссылки на исполняемый скрипт. 
Атрибут «src» указывает на внешние файлы сценариев для библиотеки React, библиотеки ReactDOM и библиотеки Babel. 
Это похоже на электрическую бритву. В любом случае вам не нравится, как бы необычная электрическая бритва, 
если вы не можете подключить ее к стене и получить доступ к электричеству. Наш код React, который мы напишем, будет нехорошим для нас, 
если наш браузер не сможет подключиться к этим библиотекам, чтобы понимать и интерпретировать то, что мы делаем. 
Это то, как наше приложение получит силу React, мы собираемся вставить React в Dom. 
Причина, по которой у нас есть React и ReactDOM в виде двух разных библиотек, заключается в том, что существуют такие случаи, 
как React Native, где рендеринг в DOM не нужен для разработки мобильных устройств, поэтому библиотека была разделена на людей, 
чтобы принять решение о том, что им нужно в зависимости о проекте, над которым они работают. Поскольку нам понадобится наш Реакт, 
чтобы добраться до DOM, мы будем использовать оба сценария. Babel - это то, как мы используем сценарий ECMA за пределами ES5 и занимаемся тем, 
что называется JSX (JavaScript как XML), которое мы будем использовать в React. Мы рассмотрим магию Вавилона на предстоящем уроке :) 
Хорошо, мы выполнили шаги 1 и 2. Мы создали код нашего boiler plate и создали среду разработки. 

### 3 - Render React в DOM

Наши следующие два шага будут состоять в том, чтобы выбрать наше местоположение в DOM, 
которое мы хотим отобразить для нашего контента React. И используя другой тег скрипта для нашего контента React внутри тела. 
Как правило, как хорошая практика разделения, все будет в собственных файлах, а затем связано с этим html-документом. 
Мы сделаем это позже на предстоящих уроках. На данный момент мы позволим этому зайти в тело html-документа, в котором мы сейчас находимся. 
Теперь мы рассмотрим, как просто выбрать место в DOM для отображения нашего контента React. Мы пойдем в тело. 
И лучшая практика заключается не только в том, чтобы бросать React в тег тела, который будет отображаться, но и создать отдельный элемент, 
часто div, который можно рассматривать как корневой элемент для вставки содержимого React. 


```javascript
<body> 
  <div id="app">React has not rendered yet</div> 
</body> 
```


Мы создадим простой элемент `<div>` и дадим ему идентификатор «app». Мы собираемся настроить таргетинг на это место, 
чтобы вставить наш контент React так же, как вы могли бы использовать CSS для таргетинга идентификатора для стиля по вашему выбору. 
Любой отредактированный контент будет отображаться в тегах div с идентификатором приложения. Тем временем мы оставим текст, говорящий, 
что «React еще не отображен». Если мы увидим это, когда мы просматриваем нашу страницу, это означает, что где-то мы пропустили рендеринг React. 
Теперь давайте продолжим и создаем тег скрипта внутри нашего тела, где мы будем создавать, чтобы реагировать в первый раз. Синтаксис, 
который нам понадобится для нашего тега скрипта, заключается в добавлении атрибута «type». Указывает тип медиафайла скрипта. 
Выше в нашей голове мы использовали атрибут src, который указывал на внешние файлы сценариев для библиотеки React, библиотеки ReactDOM и библиотеки Babel.


```javascript
<body> 
  <div id="app">React has not rendered yet</div> 
  <script type="text/babel"> 
  </script> 
</body> 
```

«Тип» скрипта, который мы используем, мы заключим в кавычки и установим его в `"text/babel"`. 
Нам понадобится эта возможность сразу использовать Babel, поскольку мы работаем с JSX. Во-первых, мы собираемся оказать React в DOM. 
Для этого мы будем использовать метод `ReactDOM.render()`. Это будет метод, и помните, что метод - это просто функция, привязанная к объекту. 
Этот метод будет принимать два аргумента.

```javascript
<body> 
  <div id="app">React has not rendered yet</div> 
  <script type="text/babel"> 
  ReactDOM.render(React What, React Where); 
 </script> 
</body> 
```


Первый аргумент - это «что» реагировать. Второй аргумент - это «где» местоположения, которое вы хотите, чтобы оно было помещено в DOM. 
Начнем с вызова нашего метода ReactDOM.render(). Наш первый аргумент будет нашим JSX.


```javascript
<body> 
  <div id="app">React has not rendered yet</div> 
  <script type="text/babel"> 
  ReactDOM.render( 
    <h1>Hello World</h1>, 
    React Where 
  ); 
 </script> 
</body> 

```](http://www.youtube.com/watch?feature=player_embedded&v=100pKUE3OPI) 


[](http://www.youtube.com/watch?feature=player_embedded&v=100pKUE3OPI)[Официальная документация React гласит](https://reactjs.org/docs/introducing-jsx.html) : «Этот синтаксис смешного тега не является ни строкой, ни HTML. Он называется JSX, и это расширение синтаксиса JavaScript. Мы рекомендуем использовать его с React для описания того, как должен выглядеть пользовательский интерфейс. JSX может напомнить вам о языке шаблонов, но он поставляется с полной мощью JavaScript. JSX создает «элементы» для реагирования ».


Часто JSX удивляет людей, которые были разработчиками на некоторое время, потому что это выглядит как HTML. 
В очень раннем возрасте разработчики обучаются разграничению проблем. HTML имеет свое место, CSS имеет свое место, и JavaScript имеет свое место. 
Кажется, что JSX размывает линии. Вы используете то, что выглядит как HTML, но, как говорит Facebook, поставляется с полной мощью JavaScript.


Это может вызывать увлечение ветеранами, так что многие учебники по React начинаются без JSX, что может быть довольно сложным. 
Мы этого не делаем. Поскольку этот курс направлен на тех, кто очень молод в своей карьере, вы не восстаните, когда увидите этот синтаксис.


И JSX просто интуитивно понятен. Возможно, вы довольно легко прочитали этот код и увидите, что это будет самый большой тег заголовка, 
отображающий текст «Hello World». Никакой тайны и довольно простой. Теперь давайте посмотрим, каков будет наш второй аргумент.

```javascript
<body> 
  <div id="app">React has not rendered yet</div> 
  <script type="text/babel"> 
    ReactDOM.render( 
      <h1>Hello World</h1>, 
      document.getElementById("app") 
    ); 
  </script> 
</body> 
```

Здесь мы хотим, чтобы наш обработанный контент был передан в дом. Вы, наверное, делали это несколько раз в прошлом. 
Мы просто наберем `document.getElementById()`. И мы перейдем к аргументу id приложения. И это все. 
Теперь мы настроим таргетинг на div с id приложения, чтобы вставить наш обработанный контент.

Мы хотим, чтобы наш контент был сохранен. Скорее откройте это в браузере, и вы увидите «Hello World». 
Как вы можете догадаться, использование React - это не самый быстрый или лучший способ создать приложение Hello World. 
Мы пока не видим преимуществ этого. Но теперь мы знаем, что все работает.

Скорее откройте консоль и посмотрите на «элементы». 
Вы можете сделать это на mac с командой + shift + j или в Windows и Linux: Ctrl + Shift + J

Если мы нажмем на тег заголовка, мы увидим скрипты наших библиотек, которые мы подключили. 
Тогда мы сможем перейти к тексту нашего документа. Давайте нажмем на наш div с идентификатором «app». 
И когда мы это сделаем, мы увидим наш `<h1>` с содержимым «Hello World».

[Весь код здесь](https://github.com/robgmerrill/hello-react/blob/master/section-one/index.html)

или

<a href="http://www.youtube.com/watch?feature=player_embedded&v=100pKUE3OPI" target="_blank"><img src="http://img.youtube.com/vi/YOUTUBE_VIDEO_ID_HERE/0.jpg" 
alt="Watch Video Here" width="240" height="180" border="10" /></a>

### Итого

Итак, давайте сделаем краткое описание. В нашем тесте head мы взяли теги скриптов для React, ReactDOM и Babel. 
Эти инструменты, в которых наш браузер нуждается в метаданных для чтения нашего кода React и JSX. 
Затем мы разместили позицию внутри DOM, которую мы хотели вставить в наш React, создав элемент div с идентификатором «app». 
Затем мы создали тег скрипта для ввода нашего кода React. Мы использовали метод ReactDOM.render(), 
который принимает два аргумента. «Что» из контента React, в данном случае нашего JSX и второго аргумента - это «где», 
в который вы хотите вставить содержимое React в DOM. В этом случае это место с идентификатором «app».


[В качестве альтернативы JSX вы можете использовать компилятор ES6 и Javascript, например, Babel.](http://www.youtube.com/watch?feature=player_embedded&v=100pKUE3OPI) [https://babeljs.io/](https://babeljs.io/)

### Дополнительная информация:

*   [Главная страница](https://reactjs.org/)
*   [Твиттер Дэн Абрамов](https://twitter.com/dan_abramov)
*   [Учебники по React на Egghead.io](https://egghead.io/browse/frameworks/react)

### Источники

1.  [«Результаты опроса разработчиков 2017.»](https://insights.stackoverflow.com/survey/2017#technology-most-loved-dreaded-and-wanted-frameworks-libraries-and-other-technologies) _Переполнение стека._ Доступ: 28 октября 2017 года.
