---
title: React Router
localeTitle: React Router
---

# React Router для начинающих

# Установка

React Router был разбит на три пакета: `react-router`, `react-router-dom` и `react-router-native`.


Вам почти никогда не придется устанавливать react-router напрямую. Этот пакет предоставляет основные компоненты и функции маршрутизации для приложений React Router. Другие два предоставляют специфические для среды (браузеры и реагирующие на) компоненты, но оба они также реэкспортируют все экспортные react-router.


Мы создаем веб-сайт (что-то, что будет запускаться в браузерах), поэтому мы нам надо установить response-router-dom.

`npm install --save react-router-dom`

# Маршрутизатор


При запуске нового проекта вам необходимо определить, какой тип маршрутизатора использовать. Для проектов на базе браузера есть также компоненты <BrowserRouter> и <HashRouter>.  `<BrowserRouter>` вы должны использовать еслить у вас есть сервер с обработкой динамических запросов (знает как ответить на любой возможный URI), в то время как <HashRouter> должен использоваться для статических сайтов (где сервер может ответить только на запросы файлов о которых он знает).

Обычно рекомендуется использовать `<BrowserRouter>`, но если ваш сайт будет размещен на сервере, который обслуживает только статические файлы, то `<HashRouter>` является хорошим решением.


Для нашего проекта мы сделаем допущение, что веб-сайт поддерживаться динамическим сервером, поэтому нашим компонентом маршрутизатора будет является `<BrowserRouter>` .


# Импортирование


```javascript
import { BrowserRouter as Router, Switch, Route, Link } from 'react-router-dom';
```

## Компонент Link


Теперь давайте добавим навигацию, чтобы у нас получилось перемещаться между страницами.

Для этого мы будем использовать компонент `<Link>` . Использование компонента `<Link>` похоже на использование тегов ссылок в html.


Из официальной документации:


Основной способ реализации перемещения по вашему приложению. Компонент `<Link>` отрисовывает полностью рабочий тег ссылки, с соответствующим адресом href. Для начала создадим компонент Nav. Наш компонент Nav будет содержать компоненты `<Link>` и выглядит следующим образом:


```javascript

const Nav = () => (
  <div>
    <Link to='/'>Home</Link>&nbsp;
    <Link to='/address'>Address</Link>
  </div>

)

```
