---
title: Why React
localeTitle: Почему React
---
## Почему React?

### Простота


React.js не является полноценной инфраструктурой Javascript, например Angular.js или другими популярными framework. Вместо этого React.js действует как «V» в MVC (Model View Controller). Это просто механизм просмотра, который можно отбросить и использовать с множеством других инструментов для части данных и модели MVC (наиболее популярно Redux и Node.js).


### Производительность

Так как React использует _Virtual DOM_ , он может выборочно обновлять части страницы по мере необходимости, а не всегда заполнять всю перезагрузку страницы. Во многих случаях не обновление всего DOM значительно экономит производительность. Более того, многие из встроенных функций (таких как функции Lifecycle) также имеют преимущества в производительности, поскольку они часто помогают проверить, требуется ли повторная обработка даже для начала.

### Низкая кривая обучения


Из доступных основных фреймворков, у React относительно низкий порог вхождения, а также более быстрый процесс обучения. Кроме того, официальная документация React является предельно ясной и дает множество примеров для большинства распространенных случаев использования.


### Инструментарий


Инструменты и программное обеспечение, обычно используемые с React, невероятно хорошо поддерживаются и поддерживаются и предоставляют несколько различных способов передового опыта, которые следует соблюдать при разработке веб-приложений. Некоторые из этих инструментов включают Redux, React-router, Thunk и многие другие. Существует также ряд средств разработки, таких как Chrome расширения для React и Redux, которые помогают отлаживать ваши React приложения.

### Поддержка

React создается и поддерживается людьми в Facebook и используется отдельными лицами и компаниями во всем мире в большом объеме. Это означает, что React постоянно совершенствуется, и у вас могут быть проблемы, которые, возможно, уже были заданы в Stack Overflow.

Помимо вышеизложенного, мы можем принять наши знания о необходимости разработки мобильных нативных приложений с использованием react-nativ, а также воспользоваться нашими знаниями и расширить его до VR с помощью react-vr. В основном обучение React, открывая нам различные другие возможности, такие как использование его для Web, VR, PWA (Progressive Web App) и многих других


#### Больше информации

Чтобы узнать больше о том, почему React настолько хорош, посмотрите [официальный сайт](https://reactjs.org/)
