---
title: Redux
localeTitle: Redux
---
## Redux

Redux является предсказуемым контейнером состояний для приложений JavaScript.

Это помогает вам писать приложения, которые ведут себя последовательно, работать в разных средах (клиент, сервер и родной), и их легко тестировать. Кроме того, он предоставляет отличные возможности для разработчиков, такие как редактирование живого кода в сочетании с отладчиком времени.

Основные принципы Redux:

1.  Redux - это контейнер состояния, он хранит все ваше состояние в одном месте
2.  Состояние доступно только для чтения, единственный способ изменить состояние - отправить действие.
3.  Государство может быть изменено только чистыми функциями или в другом терминах: Редукторы. Редукторы Redux принимают в предыдущем состоянии и объект действия и возвращают следующее состояние.

С практической точки зрения, как мы используем Redux точно?

### ПРАВИЛО 1

#### Где хранится это состояние? Redux предоставляет вам удобную функцию, называемую

```js
createStore() 
```

Где вы создаете хранилище, в котором будет сохранено ваше состояние.

### ПРАВИЛО 3 (я собираюсь сначала показать правило 3, так как это будет иметь больше смысла)

#### Состояние может быть изменено только с помощью чистой функции, например, редуктора, поэтому для создания этой связи мы перейдем к нашему редуктору к createStore ()

```js
var store = createStore(reducer) 
```

Это становится более сложным, когда у вас больше редукторов, но в основе, в магазине теперь есть редуктор, прикрепленный к нему

### ПРАВИЛО 2

#### Как только у нас есть магазин, созданный с помощью store = createStore (редуктор). Новый магазин, который мы создали, имеет метод, называемый диспетчером. Помните, что в правиле 2 единственный способ изменить состояние - это отправить действие!

Вы можете видеть, где это происходит.

```js
store.dispatch(action) 
```

Прежде чем я перейду к тому, что редуктор и какое-то действие, я думаю, показывая вам очень простую и ограниченную реализацию createStore () Redux.

```js
createStore = (reducer) => { 
    let state; 
 //dispatch method 
    dispatch = (action) => { 
        state = reducer(state, action) 
    } 
  return {dispatch} 
 } 
```

Посмотрите, как мы прошли редуктор в createStore, и он устанавливается в нашем методе отправки; и когда мы вызываем метод отправки, он принимает действие, и он устанавливает новое состояние, основанное на возврате редуктора.

## Что такое редуктор? Что такое действие?

Действие на самом базовом уровне - это объект, который имеет свойство, называемое типом. Он также может иметь другие свойства, но для простоты он будет иметь только тип.

```js
var someAction = {type:'doSomething'} 
```

Редуктор - это просто функция:

```js
var reducer = (state, action) => { 
 
    if (action.type === 'doSomething'){ 
        return changedState; 
    } else if ( action.type === 'doSomethingElse'){ 
        return changedState; 
    } else { 
        return state 
    } 
 } 
```

Действие, которое мы передаем в редуктор, определит, как изменяется состояние в зависимости от типа. Redux становится более сложным, но если вы поймете эти принципы, вам будет легче перемещаться по проектам react-redux!

#### Дополнительная информация:

##### Вам действительно нужен Redux?

[Дэн Абрамов](https://github.com/gaearon) , создатель Redux, написал некоторое время назад замечательную статью « [Вам не понадобится Redux»](https://medium.com/@dan_abramov/you-might-not-need-redux-be46360cf367) . Сначала вы должны проверить это, потому что, может быть, вам это не понадобится.

Для получения дополнительной информации перейдите по [адресу http://redux.js.org/](http://redux.js.org/)

### Ресурсы

*   [Курс от Дана Абрамова, автора Редукса.](https://egghead.io/courses/getting-started-with-redux)