---
title: Redux Actions
localeTitle: Действия Redux
---
## Действия Redux

Действие Redux - это простой объект, который описывает, какое событие произошло в вашем приложении. Они могут даже содержать данные, которые необходимо отправить из приложения в магазин Redux. Действие может содержать что угодно, но оно должно иметь обязательную тип, который описывает событие. Хорошей практикой является использование констант при описании действия.

Например

```javascript
const ADD_ITEM = 'ADD_ITEM' 
```

```javascript
{ 
 type: ADD_ITEM, 
 text: 'This is the first item' 
 } 
```

Мы можем отправить эти действия в магазин, используя `javascript store.dispatch()` Приложение может иметь разные виды событий, происходящих одновременно, и эти действия помогают описать эти события. Без этих действий невозможно изменить состояние приложения.

Вы можете попробовать проект [redux-actions,](https://github.com/redux-utilities/redux-actions) который уменьшает количество шаблонов, что позволяет быстрее писать ваши действия.

#### Дополнительная информация:

[Действия-Redux Offical Docs](https://redux.js.org/basics/actions) [Redux-действия](https://github.com/redux-utilities/redux-actions) GitHub страницу проекта