---
title: Redux Reducers
localeTitle: Редукторы Redux
---
## Редукторы Redux

Редукторы Redux позволяют вам вносить изменения в ваше состояние в вашем приложении. Действия в redux только сообщают приложению, что в основном произошло. Было ли это событие щелчка, или какой-либо прокруткой мыши, он просто скажет, что это произошло. Теперь, как вы собираетесь менять состояние своего приложения, которое живет внутри магазина, вы это делаете с помощью редуктора.

Теперь редуктор в редуксе должен быть чистой функцией. Чистая функция - это тип функции, которая не имеет дополнительных побочных эффектов. Вы передаете ему некоторые аргументы и возвращает ожидаемый результат. Например:

```javascript
function add(a,b) { 
 return a + b; 
 } 
 
 const sum = add(5,4); 
```

Вышеупомянутая функция чиста, потому что независимо от того, что произойдет, она вернется 9. Функция, которая имеет вызовы ajax внутри нее или что-то вроде доступа к базе данных, не является чистой функцией. Даже если мы мутируем изменение значения, переменное значение можно рассматривать не как чистую функцию.

Теперь, чтобы внести изменения в состояние, вы используете редуктор. Вот пример кода редуктора:

```javascript
 function todoReducer(state= [],action) { 
  case 'ADD_TODO': 
      return [...state,action.data] 
  case  'DELETE_TODO': 
      return state.filter(todo=>todo.id !== action.id) 
  default: 
      return state; 
 } 
```

Что делает этот todoReducer, так это то, что он принимает текущее состояние и действие, которое было вызвано, а затем возвращает новое состояние. Здесь мы использовали синтаксис параметров по умолчанию es6, чтобы присвоить значение по умолчанию массиву состояний. Объект действия для вышеуказанного редуктора может выглядеть следующим образом:

```javascript
{ 
 type: 'ADD_TODO', 
 data: {name: 'Learn Redux',completed:false} 
 } 
```

Здесь действие имеет свойство типа «ADD\_TODO» с объектом данных. Теперь, когда это действие инициировано, оно принимается редуктором, а затем на основе оператора switch он возвращает новый массив с существующими данными вместе с новыми данными.

Таким образом, суммировать редукторы - это не что иное, как чистые функции, которые возвращают новое состояние для вашего приложения.

#### Дополнительная информация:

[Официальные документы Redux-Reducers](https://redux.js.org/basics/reducers)