---
title: Rest API Design
localeTitle: Дизайн API для отдыха
---
### история

REST обозначает презентационный **S** татэ протокола **Т** ransfer **Re.** Рой Филдинг определил REST в своей докторской диссертации в 2000 году.

### Что это?

REST был разработан для обеспечения однородного интерфейса для

*   Определение ресурсов
*   Манипулирование ресурсами
*   Самостоятельные описательные сообщения
*   Использование Hypermedia в качестве механизма состояния приложения (HATEOS)

### Лучшие практики

*   \#### Основы

| Метод | http://api.co/v2/cars | http://api.co/v2/cars/1234 |  
| --- | --- | --- | | GET | Список всех автомобилей | Получить индивидуальный автомобиль | | ПОСТ | Создать новый автомобиль | Ошибка | | PUT | Заменить коллекцию автомобилей новым | Замените автомобиль идентификатором 1234 | | УДАЛИТЬ | Удалить все автомобили | Удалить автомобиль с идентификатором 1234 |

_Обратите внимание, что в то время как операции PUT клиент или сервер могут генерировать идентификаторы_

*   #### Существительные хорошие глаголы плохие
    
*   Используйте существительные для обозначения ресурсов, таких как `cars` , `fruits` и т. Д.
    
*   Использовать глаголы для объявлений действий `convertMilesToKms` , `getNutritionalValues`
    
*   #### Сингулярное или множественное?
    
    Используйте правильный грамматик для объявления
    
    **Избегайте** `/person/145`
    
    **Предпочитают** `/people/154` Предположим вернуть 154-го человека из списка людей
    
*   #### Использовать корпус
    
    Используйте любой из приведенных ниже шаблонов и будьте **последовательны!**
    
    | Стили стилей | Пример | | ------------- | ------------- | | **UpperCamelCase** | `http://api.fintech.cp/DailyTransactions/Today` | | **Нижняя Камелия** | `http://api.fintech.cp/dailyTransactions/today` |  
    | **snake\_case** | `http://api.fintech.cp/daily_transactions/today` |
    
*   #### **Отношения и ресурсы**
    
*   Ресурсы могут иметь отношения « `one-to-many` , « `many-to-many` , « `many-to-one` и т. Д. Картирование их правильно имеет решающее значение.
    
*   Сопоставление « **один ко многим»**
    
    Например, `Tickets/145/messages/4` предлагает отношения «один ко многим» между `tickets` и `messages` . Значение `1` билет имеет `N` сообщений. Сообщение не является автономным ресурсом. У вас не может быть `/messages/4` .
    
*   **От многих до многих**
    
    Например, `/usergroups/345/users/56` предлагает выбрать 345-ю группу пользователей и получить пользователя с идентификатором 56. Однако один пользователь может быть в нескольких `usergroups` т.е. `/usergroups/209/users/56` также действителен. В таком случае для разделения `users` ресурсов-депинантов на отдельную конечную точку, например `/users/56` и обеспечить привязку ресурсов в `/usergroups/209/users/56`
    
*   #### **Параметры API**
    
*   **PATH** : _требуется_ доступ к ресурсу Eg `/cars` , `/fruits`
    
*   **Параметры запроса** : _опционально_ фильтровать список Eg `/cars?type=SUV&year=2010`
    
*   **Тело** : специфическая для ресурсов логика. Предварительный запрос. Иногда это может быть как Query, так и body.
    
*   **Заголовок** : Должен содержать глобальные или платформенные данные. Например, параметры ключа API, зашифрованные ключи для auth, информация о типе устройства, например, мобильная или настольная или конечная точка, тип данных устройства, например xml или json. Использовать заголовок для передачи данных параметров
    
*   #### Коды статуса HTTP
    
    Использовать правильные коды состояния
    
    | Коды | Значение | | ------------- |: -------------: | | 1xx | Запрос получен и понят. | | 2xx | Было получено, понято и запрошено действие, запрошенное клиентом. | | 3xx | Клиент должен предпринять дополнительные действия для завершения запроса. Большинство этих кодов состояния используются в перенаправлении URL. | | 4xx | Предназначен для ситуаций, когда, похоже, ошибка была вызвана клиентом. | | 5xx | Сервер не выполнил запрос. |
    
    Еще немного на **2xx** !
    
*   **201 Создан ресурс.** POST `/cars` должны возвращать HTTP 201, созданный с заголовком `location` котором указывается, как получить доступ к ресурсу Например, `location` : `api.com/cars/124` в заголовке
    
*   **202 - Принято**
    
    Используйте это, если задача огромна для запуска. Скажите клиенту, он принял запрос и будет / является процессом / обработкой Не возвращается полезная нагрузка
    
*   **204 - Нет содержимого**
    
    Используется при удалении `DELETE cars/124` Возвращает содержимое. Но также может вернуть `200 OK` если API намеревается отправить удаленный ресурс для дальнейшей обработки.
    
    Опасные ресурсы **5xx** !
    
*   **500** Внутренняя ошибка сервера
    
*   **504** Тайм-аут шлюза. Сервер не получал своевременного ответа
    
    Менее известный **4xx** предполагает, что вы используете неверный параметр. Может также передавать неверную информацию. Например
    
    `DELETE /cars/MH09234`
    
    возвращает `4xx` или сообщение `Expecting int car id /car/id got string car/MH09234`
    

### **дальнейшее чтение**

[Как разработать отличные API - Parse Developer Day 2013](https://www.youtube.com/watch?v=qCdpTji8nxo)

[Бесконечная дискуссия по дизайну REST API от Guillaume Laforge](https://www.youtube.com/watch?v=48azd2VqtP0)

[Коды состояния HTTP](https://httpstatuses.com/)