---
title: Robotics
localeTitle: Робототехника
---
## Робототехника

Робототехника - это наука, которая иследует составные части (механика, электротехника, и т.д.) и программное обеспечение роботов. Нет универсального определения робота. Одно общепринятое определение: _робот - это программируемая физическая машина, которая следует за чувствовать-планировать-действовать парадигмой_ . В частности, робот должен ощущать свою окружающую среду (чувствовать), использовать эту информацию в качестве вклада для принятия решений (планировать), а затем действовать соответствующим образом (действовать). Каждая система в этой парадигме часто является само по себе изучением. Существует множество разновидностей типов роботов и систем компонентов. Каждый робот обычно относится к целому ряду процессов с четкими целями.

### Очущение мира

Робот должен чувствовать свою окружающую среду. Для этого он использует различные типы датчиков. _Датчик_ может быть определен как устройство ввода, которое преобразует физические параметры в (обычно) электрические сигналы. Камеры на вашем смартфоне - это тип датчика, которые преобразуют свет в электрические биты информации. Цифровой термометр - это датчик, который преобразует тепло (температуру) в электрический сигнал. Всегда есть ограничения точности вывода датчика, поэтому выход с датчика обычно обрабатывается, чтобы компенсировать ошибки. Чаще всего используют разные виды фильтры высоких частот (low-pass filter) с целью уменьшения шума измерений.

### Разработка плана

Робот должен принимать решения на основе ввода, который он получает от среды и способа ее программирования и по заданной командой, например двигаться из точки А в точку Б. Автономные функции - это те, которые могут выполняться роботом без какого-либо человеческого ввода. У роботов обычно есть смесь автономных и контролируемых функций (в наши дни все полностью автономные роботы становятся все более популярными). У них есть компьютер на борту, который облегчает вычисления, необходимые для процесса принятия решений роботом. Например, коммерческие [квадроторы](https://en.wikipedia.org/wiki/Quadcopter) предлагают функцию, в которой вертолет может попросить следовать за движущимся объектом. Он использует входной сигнал с камеры, выполняет [обработку изображения,](https://en.wikipedia.org/wiki/Digital_image_processing) чтобы отличить объект от окружающей среды и использует [контролируемые системы](https://en.wikipedia.org/wiki/Control_system) для наблюдения за объектом. И все это делается без какого-либо человеческого ввода (т.е. после написания программы человеком).

### Выполнение действий

Как только робот принимает решение, он должен действовать соответствующим образом. Для этой цели он использует приводы. _Привод_ - это устройство, которое преобразует энергию в движение. Приводы можно классифицировать в соответствии с типом требуемой энергии ввода. Два большинства типа исполнительных механизмов являются электрическими (которые используют электрическую энергию для генерации движения) и пневматическими (которые используют жидкости<sup>1</sup> под давлением для генерации движения). Например, двигатель является приводом, который преобразует электрическую энергию в вращательное движение. Всегда существуют ограничения точности и степени управляемости исполнительным механизмом, поэтому [системы управления](https://en.wikipedia.org/wiki/Control_system) используются для компенсации этих ограничений.

<sup>1</sup>В физике масло, вода и воздух являются жидкостью. Пневматический привод может использовать все три разновидности жидкостей.

## Важные пункты в робототехнике

Во-первых, вам нужно иметь многое терпение чтобы добиться успехом в робототехнике.

1) Углубляетесь в одном языке программирования. Самые значимые языки для робототехника: Python, C/C++, Matlab. 
2) Знакомтесь с  RaspberryPi или Arduino для приминения знаний электроники и логики в практике. Разница между RaspberryPi и Arduino: RaspberryPi - это SBC (одноплатный компьютер), а Arduino - микроконтроллер. 
3) Обратная кинематика очень важна для проетирования и дизайна манипулятора. Вот хороший ресурс для изучения [обратной кинематики](https://www.intechopen.com/books/industrial_robotics_theory_modelling_and_control/robot_kinematics__forward_and_inverse_kinematics) .

В общем эти ресурсы достаточно для того чтобы начать твоё путешествие в мире робототехники!

### Дополнительная информация:

[Роботы (Wikipedia.org)](https://en.wikipedia.org/wiki/Robot)

[Робототехника (Wikipedia.org)](https://en.wikipedia.org/wiki/Robotics)

[Датчики (electronicshub.org)](https://www.electronicshub.org/different-types-sensors/)

[Привод (Wikipedia.org)](https://en.wikipedia.org/wiki/Actuator)
