---
title: Ruby
localeTitle: Рубин
---
## Что такое Ruby?

Ruby был создан Yukihiro «Matz» Matsumoto и является [открытым](https://github.com/ruby/ruby) , динамичным и интерпретированным языком сценариев для быстрого и легкого объектно-ориентированного программирования. Что значит:

Он также известен как одно из самых [больших и дружественных сообществ](https://www.ruby-lang.org/en/community/) среди языков программирования.

*   Возможность прямого вызова операционной системы
*   Непосредственная обратная связь во время разработки
*   Переменные объявления не нужны
*   Управление памятью автоматическое
*   Все это объект
*   Имеет функциональность «mixin» по модулю
*   Итераторы и затворы

Если вы не знакомы с некоторыми из приведенных выше понятий, читайте дальше и не беспокойтесь. Ruby фокусируется на простоте и производительности благодаря элегантному синтаксису, который естественно читать и легко писать, например:

```ruby
# Quick example of Ruby with Object Oriented Programming 
 class Greeter 
  def initialize(name) 
    @name = name.capitalize 
  end 
 
  def salute 
    puts "Hello #{@name}!" 
  end 
 end 
 
 # Create a new object 
 g = Greeter.new("world") 
 
 # Output "Hello World!" 
 g.salute 
```

## Версия

Текущая стабильная версия - [2.5.1](https://www.ruby-lang.org/en/news/2018/03/28/ruby-2-5-1-released/) .

## Монтаж

Mac OS X и многие дистрибутивы Linux поставляются с предустановленной Ruby. Чтобы проверить, предварительно ли установлен рубин в вашей системе, просто запустите `ruby -v` на своей оболочке. Существует несколько способов установки Ruby:

*   Когда вы работаете в UNIX-подобной операционной системе, использование диспетчера пакетов вашей системы - самый простой способ начать работу. Однако упакованная версия Ruby обычно не самая новая.
*   Установщики могут использоваться для установки определенных или нескольких версий Ruby. Существует также программа установки для Windows.
*   Менеджеры помогают вам переключаться между несколькими установками Ruby в вашей системе.
*   И, наконец, вы также можете создать Ruby из исходного кода.

Чтобы узнать, как установить Ruby через менеджеров пакетов, инсталляторов и источник, нажмите [здесь](https://www.ruby-lang.org/en/documentation/installation/) . RVM (Ruby Version Manager) и rbenv являются самыми популярными менеджерами Ruby для управления несколькими Rubies. Если вы застряли в любом месте, не волнуйтесь, просто [перейдите](https://gitter.im/FreeCodeCamp/ruby) в нашу [комнату](https://gitter.im/FreeCodeCamp/ruby) для гостей [Gitter](https://gitter.im/FreeCodeCamp/ruby) и спросите нас что угодно.

## IRB

IRB означает Interactive Ruby Shell. Аббревиатура irb исходит из того факта, что расширение файла для Ruby равно «.rb», хотя интерактивные файлы Ruby не имеют расширения «.irb». Программа запускается из командной строки и позволяет выполнять команды Ruby с немедленным ответом, экспериментируя в режиме реального времени. Он содержит историю команд, возможности редактирования строк и управление заданиями и может напрямую связываться как сценарий оболочки через Интернет и взаимодействовать с сервером в реальном времени. Он был разработан Keiju Ishitsuka.

```shell
    irb 
    2.3.0 :001 > print "Hello World" 
    Hello World! => nil 
```

## Рубиновый переводчик

Интерпретатор Ruby - это то, что используется для запуска скриптов Ruby. Если он доступен и в пути поиска оболочки Unix можно запустить его, введя команду `ruby` за которой следует имя сценария, вызывается интерпретатор и запускается скрипт.

`hello_campers.rb`

```ruby
    if 'welcome' == 'welcome' 
        print('Hello campers!') 
    end 
```

Из командной строки:

```shell
    $ ruby hello_campers.rb 
    Hello campers! 
```

## Документация

Ruby хорошо [документирован](https://www.ruby-lang.org/en/documentation/) . Эти документы включают в себя руководства, руководства, ссылки и метаинформацию для языка.  
Другим важным источником документации является [Ruby Doc](http://ruby-doc.org/core-2.3.0/) . Вы должны посетить эту [ссылку,](https://github.com/airbnb/ruby) чтобы узнать больше о руководстве по стилю Ruby, написанном разработчиками AirBnB.

Рекомендуемое чтение для новичков в Ruby - [это руководство Why (Poignant) для Ruby](https://poignant.guide/) Эта книга необычна среди книг по программированию. С довольно много странным юмором и повествовательными боковыми дорожками, которые иногда совершенно не связаны с темой, этому удается удержать читателей, пока они изучают основы Ruby.

## отладка

Операторы внутренней `print` могут использоваться для простой отладки:

```ruby
    print some_variable # prints to console 
```

> **... часто самый быстрый способ отладки программы состоит в том, чтобы добавить в исходный код несколько операторов печати: быстрый цикл редактирования-тестирования-отладки делает этот простой подход очень эффективным.**

Ruby также включает в себя более мощные инструменты для отладки, такие как:

*   [_подглядывать-отладчик_](https://github.com/nixme/pry-debugger)

## Привет, мир!

Возвращаясь к документам, мы можем прочитать о методе [`print`](http://ruby-doc.org/core-2.3.0/Kernel.html#method-i-print) , одном из встроенных методов [модуля Kernel](http://ruby-doc.org/core-2.3.0/Kernel.html) .

```ruby
    print(obj, ...) → nil 
```

Печать каждого объекта в $ stdout. Объекты, которые не являются строками, будут преобразованы путем вызова метода `to_s` . Возвращаемое значение печати равно `nil` . Поэтому, когда вы запускаете `print "Hello World!` В вашем IRB, вы получаете:

```shell
    2.3.0 :001 > print "Hello World!" 
    Hello World! 
     => nil 
```

## Каркасы (драгоценные камни)

Ruby имеет несколько фреймворков (драгоценных камней) для быстрых приложений для строительных лесов. Самым популярным на сегодняшний день является [Rails,](http://rubyonrails.org/) который был первоначально выпущен в 2004 году. Другие рамки (драгоценные камни) для Ruby включают [Sinatra](http://www.sinatrarb.com/) , [Lotus](http://lotusrb.org/) и [Volt](http://voltframework.com/) . Каждый из этих вариантов имеет свои плюсы и минусы для разработки и удовлетворения разнообразных потребностей.

## Ruby Framework для мобильных разработок

Для написания кросс-платформенных родных приложений в Ruby, Ruby MOTION используется для разработки кросс-платформенных родных приложений для iOS, Android и OS X с использованием языкового программирования Ruby. Больше ресурсов здесь: http://www.rubymotion.com/

## Что после изучения Руби?

Каждый язык программирования играет важную роль. Вы можете внести свой вклад в большое количество проектов с открытым исходным кодом, или вы можете подать заявку на некоторые крупные компании после того, как вы хорошо разбираетесь в Ruby. Как многие крупные интернет-сайты, такие как Basecamp, Airbnb, Bleacher Report, Fab.com, Scribd, Groupon, Gumroad, Hulu, Kickstarter, Pitchfork, Sendgrid, Soundcloud, Square, Yammer, Crunchbase, Slideshare, Funny или Die, Zendesk, GitHub, Shopify построены на Ruby, поэтому у вас есть много вариантов. Кроме того, многие стартапы нанимают людей, которые обладают навыками в RUby on Rails, поскольку не многие программисты пытаются изучить Ruby. Таким образом, у вас может быть четкое сокращение работы в стартап-компании. Итак, Ruby новичок дружелюбный и довольно сложный навык, чтобы найти у вас большое количество открытий для работы в качестве разработчика.
