---
title: Rubocop
localeTitle: Rubocop
---
[Rubocop](https://github.com/bbatsov/rubocop) является инструментом статического анализа для [Рубин](https://www.ruby-lang.org/en/) . Что это значит? Это означает, что Rubocop будет «читать» ваш код (в отличие от его запуска, следовательно, «статическая» часть от имени) и проанализировать его. Правила использования Rubocop используются из [Руководство по стилю сообщества Ruby](https://github.com/bbatsov/ruby-style-guide) .

Руководство по стилю представляет собой набор конкретных предложений о том, как писать код, который более читабельна, более выразительна и более условна. Как сообщество, это было бы замечательно, если бы мы могли легко читать чужой код, и они могли бы читать легко. Это то, что нам помогает Rubocop. Этот инструмент всегда ценный, но он особенно полезен, когда вы изучаете Ruby и вы можете ввести код, который является _правильным_ , но который не придерживается конвенций Ruby, или не использует некоторые из более мощных функций Ruby.

Наиболее полезно, Rubocop может автоматически исправить многие незначительные предупреждения - например, неправильный интервал. Это очень полезно перед просмотром кода, поскольку это означает, что коллеги-разработчики могут сосредоточиться на проблемах более высокого уровня и не тратить время по вопросам синтаксиса.

## Использование Rubocop

### Монтаж

Rubocop поставляется как драгоценный камень, поэтому в типичном проекте, который использует Bundler, вы добавит его в раздел разработки вашего `Gemfile` :
```
group :development do 
  gem rubocop 
 end 
```

Это означает, что любой, кто использует ваш проект, будет иметь ту же версию Rubocop, и все согласятся с тем, какова нынешняя лучшая практика.

### использование

Перед каждым фиксацией мне нравится проверять, что мой новый модифицированный код соответствует стандарт коммьюнити, просто запустив:
```
rubocop 
```

Это выведет список предупреждений о вашем коде.

Полезно спросить Rubocop за дополнительной помощью:
```
rubocop --extra-details --display-cop-names 
```

(Вы можете добавить их в файл `.rubocop` чтобы сделать их по умолчанию.)

Многие редакторы позволят вам интегрировать Rubocop, который может когда вы пишете код.

### Устранение неполадок

Допустим, я написал новый код; прежде чем я его совершу, я могу решить убедитесь, что оно соответствует рекомендациям:

```shell
rubocop <my new file> 
```

Я могу редактировать внесенные изменения вручную, или я могу попросить Rubocop исправить незначительные проблемы автоматически:
```
rubocop --auto-correct 
```

### Запуск только определенных полицейских

Каждое руководство сообщества реализуется в рубикоповом «полицейском». При работе над устаревшей кодовой базы, вы можете быть загружены с предупреждениями при представлении Rubocop. В этом случае часто бывает полезно запустить только одного копа codebase и проверьте эти изменения, прежде чем перейти к следующему руководству, для пример:
```
rubocop --auto-correct --only 'Layout/EmptyLineAfterMagicComment' 
```

### Интеграция текстового редактора

Rubocop можно интегрировать с Vim, Visual Studio Code, Atom и другими текстовыми редакторами. Полный список можно найти [здесь](https://rubocop.readthedocs.io/en/latest/integration_with_other_tools/) .