---
title: Ruby Arrays
localeTitle: Рубиновые массивы
---
## Рубиновые массивы

Массив представляет список значений. Отдельные значения часто называют «элементами» массива. Чтобы создать массив в Ruby, используйте квадратные скобки и отдельные значения с запятыми:

```ruby
my_array = [1, 2, 3, 4, 5] 
```

Этот первый пример представляет собой массив чисел, но массив Ruby может содержать значения разных типов, даже других массивов:

```ruby
mixed_array = [5, "Hello World", true, [1,2,3]] 
```

Вы можете получить доступ к элементам массива с квадратными скобками и числовыми индексами. Обратите внимание, что первый элемент имеет индекс 0, а не 1:

```ruby
mixed_array[0] # 5 
 mixed_array[1] # "Hello World" 
 mixed_array[2] # true 
```

Вы можете проверить, сколько элементов имеет массив с методом `length` :

```ruby
mixed_array.length # 3 
 [].length # 0 
```

Вы можете проверить первый элемент массива с помощью `first` метода:

```ruby
mixed_array.first # 5 
```

Вы можете проверить последний элемент массива `last` методом:

```ruby
mixed_array.last # true 
```

#### Ruby Lambda

Лямбду также обычно называют анонимной функцией. Чтобы создать лямбда в Ruby, вы можете использовать следующий синтаксис:

```ruby
lambda = lambda {} 
```

#### Дополнительная информация:

[Документация массива Ruby](https://ruby-doc.org/core-2.4.2/Array.html)