---
title: Ruby Methods
localeTitle: Рубиновые методы
---
## Введение

Вы когда-нибудь слышали о языках программирования, относящихся к функциям? Если вы закодированы в JavaScript, вы должны быть слишком знакомы с ними. Ruby также имеет функции, но мы называем их методами. Методы - это просто комплекты блоков кода, которым дано имя для удобства использования и доступности, и они имеют решающее значение для подхода DRY (не повторяйте себя) при программировании.

## Создание и использование методов

Методы всегда должны быть определены как строчные (вы можете отделить слова с подчеркиванием, если хотите), иначе их можно путать как константы. Методы также должны быть определены до фактического их вызова, поэтому эмпирическое правило будет создавать ваши методы в начале вашего файла и называть их потом, когда это необходимо. Всегда старайтесь избегать одиночных имен имен слов, где это необходимо, вы хотите иметь возможность знать более или менее то, что делает этот метод, без необходимости копать внутри.

## Синтаксис

Способы достаточно просты в создании, они могут быть созданы без возможности принимать параметры, с параметрами и даже с заранее определенными параметрами, если они не указаны.

#### Простой метод
```
def my_method 
  code goes here 
 end 
```

#### Метод приема параметров
```
def my_method (param1, param2) 
  param1 + param2 
 end 
```

#### Предопределенный параметрический метод (предопределенные параметры используются, когда ни один не задан)
```
def my_method (param1 = parameter1, param2 = parameter2) 
  parm1 + parm2 
 end 
```

## Возвращение в методах

Возвращаемое значение метода всегда будет последним оцененным выражением в методе. Однако вы можете использовать ключевое слово return для возврата более одного значения, если это необходимо.