---
title: Ruby on Rails
localeTitle: Рубин на рельсах
---
# Рубин на рельсах

[Ruby on Rails](http://rubyonrails.org/) - это серверная структура (gem), построенная на языке Ruby для создания веб-сайтов. Rails делает веб-разработку быстрее, проще и веселее. Он включает в себя все, что вам нужно для создания фантастических приложений и имеет большое сообщество. Rails был создан Дэвидом Хайннемером Ханссоном и в настоящее время находится на 5-й версии. Rails подчеркивает использование других известных программных паттернов и парадигм разработки программного обеспечения, включая [соглашение по конфигурации (CoC)](https://en.wikipedia.org/wiki/Convention_over_configuration) , [не повторяйте себя (DRY)](https://en.wikipedia.org/wiki/Don%27t_repeat_yourself) и активный шаблон записи. Rails - это [модель-контроллер-контроллер (MVC)](https://en.wikipedia.org/wiki/Model%E2%80%93view%E2%80%93controller) , предоставляющая структуры по умолчанию для базы данных, веб-службы и веб-страниц. В последнее время Rails интегрировал модуль API, который упростил создание веб-сервисов.

## Установка Rails

Rails загружается так же, как и любой другой камень Ruby: с помощью команды `gem install` . Прежде чем загрузить его, нам нужно будет [загрузить Ruby](https://www.ruby-lang.org) . Впоследствии мы находимся всего в 3 словах от начала работы с Ruby on Rails:

```shell
$ gem install rails 
```

## Настройка базы данных

Rails поставляется с sqlite3 в качестве базы данных по умолчанию, которая представляет собой простой файл на диске. Вам нужно установить MySQL или PostgreSQL, если вы хотите использовать что-то более надежное.

## Создание приложения Rails

1.  После установки Ruby on Rails очень просто создать совершенно новое приложение, нам понадобятся еще 3 слова:

```shell
$ rails new your_application_name 
```

*   Если вы хотите использовать MySQL `shell $ rails new <application_name> -d mysql`
*   Если вы хотите использовать Postgres `shell $ rails new <application_name> -d postgresql`

1.  Эта команда создаст папку с _именем вашего _приложения, которое__ вы указали в последней команде. Следующий шаг - перейти в новый созданный вами каталог:

```shell
$ cd your_application_name 
```

3.  Перед запуском приложения получите необходимые драгоценные камни и пакеты программного обеспечения:

```shell
$ bundle install 
```

4.  Чтобы запустить сервер rails и посмотреть, все ли идет соответственно, также быстро:

```shell
$ rails server 
```

Это не могло быть проще! Ну, на самом деле это не на самом деле 100%, мы могли бы сделать это еще меньше, уменьшив команду `rails server` до:

```shell
$ rails s 
```

5.  Теперь, с вашим предпочтительным браузером, перейдите по `http://localhost:3000` и вы увидите: «Yay! You're on Rails!»

### Альтернативный метод создания приложения Rails

1.  Создайте новый каталог:
    
    ```shell
    $ mkdir <application_name> 
    
    ```
    
2.  Перейдите в новый каталог:
    
    ```shell
    $ cd <application_name> 
    
    ```
    
3.  Создайте приложение Rails, используя нотацию Unix. Это приводит к назначению имени каталога новому приложению.
    
    ```shell
    $ rails new . 
    
    ```
    
4.  Начните исследовать структуру созданного вами приложения. Структура папок организована в соответствии со следующей таблицей:
    

| Файл / Папка | Цель |  
| ----------- | ------- |  
| приложение / | Содержит контроллеры, модели, представления, помощники, почтовые программы, каналы, задания и активы для вашего приложения. Вы остановитесь на этой папке для остальной части этого руководства. |  
| bin / | Содержит скрипт rails, который запускает ваше приложение и может содержать другие скрипты, которые вы используете для настройки, обновления, развертывания или запуска приложения. |  
| config / | Настройте маршруты, базу данных и многое другое. Это более подробно описано в разделе «Настройка приложений Rails». |  
| config.ru | Конфигурация стойки для серверов на стойке, используемых для запуска приложения. |  
| db / | Содержит вашу текущую схему базы данных, а также миграцию базы данных. |  
| Gemfile, Gemfile.lock | Эти файлы позволяют указать, какие зависимости от gem необходимы для вашего приложения Rails. Эти файлы используются жемчужиной Bundler. Для получения дополнительной информации о Bundler см. Веб-сайт Bundler. |  
| lib / | Расширенные модули для вашего приложения. |  
| log / | Файлы журналов приложений. |  
| общественность / | Единственная папка, которую видит мир как есть. Содержит статические файлы и скомпилированные активы. |  
| Rakefile | Этот файл находит и загружает задачи, которые могут выполняться из командной строки. Определения задач определяются во всех компонентах Rails. Вместо того, чтобы изменять Rakefile, вы должны добавить свои собственные задачи, добавив файлы в каталог lib / tasks вашего приложения. |  
| README.md | Это краткое руководство для вашего приложения. Вы должны отредактировать этот файл, чтобы сообщить другим, что делает ваше приложение, как его настроить, и так далее. |  
| тест / | Единичные испытания, приборы и другие испытательные устройства. Они описаны в приложениях для тестирования Rails. |  
| tmp / | Временные файлы (например, файлы кеша и pid). |  
| поставщик / | Место для всех сторонних кодов. В типичном приложении Rails это включает в себя драгоценные камни. |  
| .gitignore | Этот файл сообщает git, какие файлы (или шаблоны) он должен игнорировать. См. GitHub - Игнорирование файлов для получения дополнительной информации об игнорировании файлов. |

Отличное место для начала работы с этой замечательной картой - это прочитать его [страницу «Начало работы»](http://guides.rubyonrails.org/getting_started.html) .

## Конвенция по конфигурации

_Конвенция по конфигурации_ означает, что разработчику необходимо указывать нетрадиционные аспекты приложения. Например, если в модели есть класс `Sale` , соответствующая таблица в базе данных называется `sales` по умолчанию. Только если кто-то отклоняется от этого соглашения, например, вызывая таблицу «проданных продуктов», разработчику необходимо написать код, касающийся этих имен. Как правило, соглашения Ruby on Rails приводят к меньшему количеству кода и меньшему количеству повторений.

## Что такое MVC?

Модель (активная запись) содержит бизнес-логику и взаимодействует с базой данных. Представления (Action views) всех HTML-файлов и структуры. Контроллер (Action controller) взаимодействует с представлениями и моделью, чтобы управлять действиями приложения.

## DRY - не повторяйте себя

_Не повторять себя_ означает, что информация находится в одном, недвусмысленном месте. Например, используя модуль ActiveRecord Rails, разработчику не нужно указывать имена столбцов базы данных в определениях классов. Вместо этого Ruby on Rails может извлекать эту информацию из базы данных на основе имени класса.

## Ruby on Rails - с открытым исходным кодом

Он не только свободен в использовании, но и помогает сделать его лучше. Более 4500 человек уже внесли код в [Rails](https://github.com/rails/rails) . Это проще, чем вы думаете, чтобы стать одним из них.
