---
title: Ruby String Interpolation
localeTitle: Интерполирование Ruby String
---
# Интерполяция строк

Строковая интерполяция обеспечивает более читаемый и сжатый синтаксис для построения строк. Вы можете быть знакомы с конкатенацией с помощью методов `+` или `<<` :

```ruby
"Hello " + "World!" #=> Hello World 
 "Hello " << "World!" #=> Hello World 
```

Строковая интерполяция обеспечивает способ вставки кода Ruby непосредственно в строку:

```ruby
place = "World" 
 "Hello #{place}!" #=> Hello World! 
 
 "4 + 4 is #{4 + 4}" #=> 4 + 4 is 8 
```

Все между `#{` и `}` оценивается как код Ruby. Для этого строка должна быть окружена двойными кавычками ( `"` ).

Одиночные кавычки вернут точную строку внутри кавычек:

```ruby
place = "World" 
 'Hello #{place}!' #=> Hello #{place}! 

```