---
title: Rust
localeTitle: Ржавчина
---
# Ржавчина

## Введение

Rust - это язык системного программирования, ориентированный на три цели: безопасность, скорость и параллелизм. Его дизайн позволяет создавать программы, которые имеют производительность и управление языком низкого уровня, но с мощными абстракциями языка высокого уровня. Эти свойства делают Rust подходящим для программистов, которые имеют опыт работы на таких языках, как C, и ищут более безопасную альтернативу, а также такие языки, как Python, которые ищут способы написания кода, который работает лучше, не жертвуя выразительностью. Rust запускает большинство своих проверок безопасности и решений по управлению памятью во время компиляции, так что производительность выполнения вашей программы не влияет. Это делает его полезным в ряде случаев, когда другие языки не подходят: программы с предсказуемыми требованиями к пространству и времени, встраивание в другие языки и запись низкоуровневого кода, например драйверов устройств и операционных систем. Также для веб-приложений также используется сайт реестра пакета Rust, [crates.io](https://www.crates.io) .

Для получения дополнительной информации [перейдите на главную страницу Rust](https://www.rust-lang.org) .

## Монтаж

Разработчики ржавчины чрезвычайно упрощают установку и управление ржавчиной в вашей системе. Это достигается с помощью инструмента `rustup` который позволяет не только устанавливать `rustc` компилятор `rustc` , но также легко переключаться между стабильными, бета-версиями и ночными версиями компилятора и поддерживать их в актуальном состоянии.

Официальную документацию по установке можно найти [здесь](https://doc.rust-lang.org/book/second-edition/ch01-01-installation.html) .

### Linux или Mac

Если вы используете Linux или Mac, установка `rustup` лучше всего сделать через терминал:

```bash
$ curl https://sh.rustup.rs -sSf | sh 
```

Это загрузит и запустит скрипт на ваш компьютер, который установит этот инструмент. Скрипт установки автоматически добавляет Rust к вашей системе `PATH` после вашего следующего входа.

### Windows

В Windows перейдите на [сайт rustup](https://rustup.rs) и следуйте инструкциям по загрузке `rustup-init.exe` . Запустите это и следуйте остальным инструкциям, которые он вам дает.

### обновление

Как только вы установили `rustup` , обновление до более новых версий прост. Все, что вам нужно запустить:

```bash
$ rustup update 
```

Чтобы просмотреть текущий номер версии, зафиксировать хеш и дату фиксации вашего компилятора ржавчины, выполните следующую команду:

```bash
$ rustc --version 
 rustc xyz (abcabcabc yyyy-mm-dd) 
```

### Удаление

Удаление ржавчины из вашей системы так же просто, как и установка:

```bash
$ rustup self uninstall 

```