---
title: Loops
localeTitle: Loops
---
# Loops

Внутри Rust существует три типа встроенных механизмов циклизации: `loop` , `while` и `for` .

## Бесконечное повторение с `loop`

В Rust структура `loop` будет непрерывно выполнять блок кода ad infinitum (или пока вы явно не остановите его).

Вот пример программы, использующей `loop` для непрерывного вывода слова «снова» на терминал:

```rust
fn main() { 
    loop { 
        println!("again!"); 
    } 
 } 
```

## Условный цикл с `while`

Вышеупомянутый механизм не очень полезен, если мы не вводим какое-то условие остановки для `loop` для которого нужно проверить. К счастью, Rust имеет встроенную циклическую структуру, называемую `while` , которую вы можете использовать для непрерывного выполнения блока кода, в то время как какое-то условие истинно.

Вот пример программы, использующей `while` для обратного отсчета от 5:

```rust
fn main() { 
    let mut number = 5; 
 
    while number != 0 { 
        println!("{}", number); 
        number = number - 1; 
    } 
 } 
```

Выполните [здесь](https://play.rust-lang.org/?gist=62677371a8590be27c84dcae7068de57&version=stable) код.

## Перебор коллекции с `for`

В некоторых случаях вам может потребоваться повторить и использовать элементы коллекции (например, массив). В то время как вы могли бы добиться этого с помощью `while` цикл и индексную переменную для доступа к каждому элементу, Rust предоставляет `for` цикла , чтобы сделать эту операцию гораздо проще.

Вот пример программы, которая печатает каждое число в массиве на терминал, используя `for` :

```rust
fn main() { 
    let collection = [15, 7, 2, 6, 9]; 
 
    for element in collection.iter() { 
        println!("the value is: {}", element); 
    } 
 } 
```

Выполните [здесь](https://play.rust-lang.org/?gist=0c2acf21b96a81ebd411e4a7dc5a19fd&version=stable) код.

Подобно итераторам в C ++, `.iter()` возвращает итератор в `collection` , который затем может быть зациклирован для доступа к каждому `element` . Для получения дополнительной информации перейдите к документации Rust по [потоку управления](https://doc.rust-lang.org/book/second-edition/ch03-05-control-flow.html) .