---
title: Confidentiality Integrity Availability
localeTitle: Доступность конфиденциальности
---
## Конфиденциальность, честность, доступность (ЦРУ)

Конфиденциальность, честность и доступность или триада ЦРУ - самая фундаментальная концепция кибербезопасности. Он служит руководящими принципами или целями обеспечения информационной безопасности для организаций и отдельных лиц для обеспечения безопасности информации от любопытных глаз.

### конфиденциальность

Конфиденциальность заключается в обеспечении доступа к данным, ограничивается только целевой аудиторией, а не другими. Как вы можете ожидать, чем более чувствительна информация, тем более строгие меры безопасности должны быть. Многие законы о конфиденциальности полагаются на средства обеспечения безопасности конфиденциальности, чтобы обеспечить соблюдение правовых требований.

Некоторые меры по сохранению конфиденциальности информации:

*   шифрование
*   пароль
*   Двухфакторная аутентификация
*   Биометрические
*   Защитные жетоны

### целостность

Целостность относится к поддержанию точности и полноты данных. Другими словами, речь идет о защите данных от их модификации неавторизованными сторонами, случайно авторизованными сторонами или непреднамеренными событиями, такими как электромагнитный импульс или сбой сервера. Например, хакер может перехватывать данные и изменять их перед отправкой получателю.

Меры по обеспечению целостности информации включают:

*   шифрование
*   хеширования
*   Управление доступом пользователей
*   Контрольные суммы
*   Контроль версий
*   Резервные копии

### Доступность

Наконец, информация должна быть доступна, когда это необходимо. Чтобы обеспечить высокую доступность данных, вы должны поддерживать правильно функционирующее аппаратное и программное обеспечение и обеспечивать достаточную пропускную способность. Но одних только этих мер недостаточно, потому что в игре есть внешние силы; доступность данных также может быть скомпрометирована:

*   Отказ в обслуживании (DoS)
*   Перебои питания
*   Стихийные бедствия

Например, DoS может использоваться конкурирующей компанией, чтобы разорвать ваш сайт, чтобы его собственный сайт стал более популярным.

Меры по снижению угроз доступности включают:

*   Резервные копии вне площадки
*   Аварийное восстановление
*   избыточность
*   Отказоустойчивость
*   RAID
*   Классы высокой доступности

### Вызовы для Триады ЦРУ

Специальные задачи для триады ЦРУ:

**Большие данные** создают дополнительные проблемы для парадигмы ЦРУ из-за огромного объема информации, которая должна быть безопасно охранной, множества источников, из которых она исходит, и множества форматов, в которых она существует. Дублированные наборы данных и планы аварийного восстановления могут умножать и без того высокие затраты. Кроме того, поскольку основная проблема больших данных заключается в сборе и предоставлении какой-либо полезной интерпретации всей этой информации, часто не хватает ответственного контроля над данными.

**Интернет конфиденциальности** - это особые соображения, необходимые для защиты информации отдельных лиц от воздействия в среде IoT, в которой практически любому физическому или логическому объекту или объекту может быть предоставлен уникальный идентификатор и возможность автономного общения через Интернет или аналогичные сеть. Данные, передаваемые данной конечной точкой, могут не вызывать проблемы конфиденциальности самостоятельно. Однако, когда даже фрагментированные данные из нескольких конечных точек собираются, сопоставляются и анализируются, они могут давать конфиденциальную информацию.

**Безопасность Internet of Things** также является особой проблемой, потому что IoT состоит из множества устройств с поддержкой Интернета, отличных от компьютеров, которые часто не передаются и часто настроены с использованием дефолтных или слабых паролей. Если они не защищены должным образом, вещи IoT могут использоваться как отдельные векторы атаки или часть вещного знака. Поскольку все больше и больше продуктов разрабатываются с возможностью подключения к сети, важно регулярно рассматривать безопасность в разработке продукта.

### Дополнительная информация: [конфиденциальность, целостность и доступность (триада ЦРУ)](http://whatis.techtarget.com/definition/Confidentiality-integrity-and-availability-CIA)

Помимо триады ЦРУ, в информационной безопасности есть и другие часто повторяющиеся темы:

*   безоговорочность: уверенность в том, что кто-то / что-то не может что-то отрицать (например, нельзя отрицать подлинность цифровой подписи)
*   аутентификация: подтверждение того, что лицо является тем, кого они утверждают
*   надежность: уверенность в зависимости от системы или процесса
*   конфиденциальность: обобщенный аналог конфиденциальности, который также затрагивает социальные последствия несоблюдения требования