---
title: Cryptography
localeTitle: криптография
---
## криптография

Основная цель криптографии - дать возможность двум людям общаться по незащищенному каналу таким образом, чтобы третий человек не мог понять, что говорится. Этот канал может быть телефонной линией или компьютерной сетью.

Криптография начала использоваться римлянами, чтобы сообщения в битве были нечитаемы противником, если они дешифрованы.

Криптография до современной эпохи была фактически синонимом шифрования, превращения информации из читаемого состояния в очевидную бессмыслицу.

Современная криптография используется в данных, так что только одна сторона или только уполномоченные стороны имеют возможность доступа к информации.

Шифрование на протяжении многих лет стало более совершенным.

### пример

Информация, которую Person1 хочет отправить Person2, которую мы называем «открытым текстом», может быть текстовым, цифровым или любым типом данных. Person1 шифрует открытый текст с использованием предопределенного ключа и отправляет полученный «зашифрованный текст» по каналу. Person3, увидев зашифрованный текст в канале, не может определить, что такое открытый текст, но Person2, который знает ключ шифрования, может расшифровать зашифрованный текст и восстановить открытый текст.

### Цезарь Сифер (Shift Cypher)

Первым известным cypher был Ceasar cypher. Цезарский шифр работает, перемещая буквы «открытого текста» на определенную величину вверх или вниз в алфавите.

С точки зрения внешнего лица сообщение представляется случайными буквами с пробелами между ними.

### Современная криптография

Современное шифрование использует почти случайные числа и математически звуковые функции, чтобы обеспечить безопасную связь. Эти недавно разработанные функциональные возможности не могут быть легко взломаны из-за их структуры, требуя, чтобы даже суперкомпьютеры сотни лет трескались.

Существует два основных типа современного шифрования:

### 1) Симметричное или одно ключевое шифрование:

Симметричное шифрование ключей - это метод шифрования, в котором обе стороны используют только один ключ для шифрования и дешифрования. Эти алгоритмы, благодаря их дизайну, обычно намного быстрее, чем асимметричное или шифрование с открытым ключом.

Некоторые методы симметричного шифрования включают в себя: Стандарт шифрования данных (DES), Стандарт предварительного шифрования (AES), Blow Fish, Two Fish, RC4.

### 2) Асимметричное или публичное шифрование ключей:

Асимметричные алгоритмы шифрования предоставляют каждому пользователю пару ключей: одну общедоступную и одну приватную. Любое сообщение, зашифрованное одним ключом из пары, может быть расшифровано только с другого.

Некоторые асимметричные методы включают: RSA, Diffie-Hellman, DSS (стандарт цифровой подписи), ElGamal.

### Криптографическое Хеширование

Большинство криптографических хэш-функций предназначены для ввода строки любой длины в качестве входных данных и получения хэш-значения фиксированной длины.

Криптографическая хеш-функция должна выдерживать все известные типы криптоаналитической атаки.

### Хрипление криптографии

Криптографическая хеш-функция - это тип хеш-функции, которая также предназначена для односторонней функции (функция, которая требует слишком много времени и ресурсов для перебора). Основная цель хэшей связана с несовместимостью сообщений, поэтому одно и то же сообщение всегда приводит к одному и тому же хэшу.

#### Дополнительная информация:

*   [Криптография: теория и практика Дугласа Стинсона](https://www.crcpress.com/Cryptography-Theory-and-Practice-Third-Edition/Stinson/p/book/9781584885085)
*   [TechTarget для шифрования](http://searchsecurity.techtarget.com/definition/encryption)
*   [Руководство по криптографии](https://www.tutorialspoint.com/cryptography/index.htm)