---
title: DDoS Distributed Denial of Service
localeTitle: Распространенный отказ в обслуживании DDoS
---
Атака на отказ в обслуживании (DOS) - это когда злоумышленник пытается нарушить работу сервера, обманув его несколькими поддельными запросами и не позволяя фактическим пользователям получать доступ к службе. Распределенная атака DOS - это когда атака происходит из нескольких мест одновременно, что затрудняет для команды кибер-безопасности обнаружение и обработку атаки.

Атака распределенного отказа в обслуживании (DDoS) - попытка сделать онлайн-сервис или веб-сайт недоступным, перегружая его огромными потоками трафика, генерируемыми из нескольких источников.

В отличие от атаки на отказ в обслуживании (DoS), в которой один компьютер и одно подключение к Интернету используются для наложения целевого ресурса пакетами, DDoS-атака использует множество компьютеров и множество интернет-соединений, часто распространяемых по всему миру в так называемой бот-сети ,

Атаки DDoS обычно нацелены на огромные корпорации, где отказ в обслуживании на несколько минут может перевести на миллионы долларов.

Существует несколько видов атак Ddos, и лучшая атака определяется путем изучения уязвимостей цели.

### Типы DDoS-атак

Атаки DDoS можно разделить на три категории:

1.  Атаки на основе тома
2.  Атаки протоколов
3.  Атаки уровня приложения

### Атаки на основе объема

Атаки на основе томов включают в себя потоки TCP, наводнения UDP, наводнения ICMP и другие потоки поддельных пакетов. Они также называются атаками уровня 3 и 4 \*. Здесь злоумышленник пытается насытить пропускную способность целевого сайта. Величина атаки измеряется в битах в секунду (бит / с).

*   **Потоп UDP. Поток** UDP используется для наложения случайных портов на удаленном узле с многочисленными пакетами UDP, точнее на номер порта 53. Специализированные брандмауэры могут использоваться для фильтрации или блокирования вредоносных UDP-пакетов.
    
*   **ICMP Flood** - это похоже на поток UDP и используется для заливки удаленного хоста многочисленными запросами эхолота ICMP. Этот тип атаки может потреблять как исходящую, так и входящую полосу пропускания, а высокий объем запросов ping приведет к общему спаду системы.
    
*   **HTTP Flood** - злоумышленник отправляет HTTP GET и POST-запросы на целевой веб-сервер на большом томе, который не может быть обработан сервером и приводит к отказу от дополнительных подключений от законных клиентов.
    
*   **Атака усилителя** - злоумышленник делает запрос, который генерирует большой ответ, который включает запросы DNS для больших записей TXT и HTTP GET-запросов для больших файлов, таких как изображения, PDF-файлы или любые другие файлы данных.
    

### Атаки протоколов

Атаки с протоколом включают в себя потоки SYN, Ping of Death, фрагментированные атаки пакетов, DDoS Smurf и т. Д. Этот тип атаки потребляет фактические серверные ресурсы и другие ресурсы, такие как брандмауэры и балансировки нагрузки. Величина атаки измеряется в пакетах в секунду.

*   **Потоки DNS. Наводнения** DNS используются для атаки как инфраструктуры, так и приложения DNS для подавления целевой системы и использования всей имеющейся пропускной способности сети.
    
*   **SYN Flood** - злоумышленник отправляет запросы TCP-соединения быстрее, чем целевая машина может их обрабатывать, вызывая насыщенность сети. Администраторы могут настраивать стеки TCP для смягчения последствий наводнений SYN. Чтобы уменьшить эффект наводнений SYN, вы можете сократить время ожидания до тех пор, пока стек не освободит память, выделенную для подключения, или выборочно удаляет входящие соединения с использованием брандмауэра или iptables.
    
*   **Ping of Death** - злоумышленник отправляет неправильные или негабаритные пакеты с помощью простой команды ping. IP позволяет отправлять 65,535 байт-пакетов, но отправка пакета ping более 65535 байт нарушает Интернет-протокол и может привести к переполнению памяти в целевой системе и, наконец, к сбою системы. Чтобы избежать атак Ping of Death и его вариантов, многие сайты блокируют сообщения ICMP ping вообще на своих брандмауэрах.
    

### Атаки уровня приложения

Атаки уровня приложения включают в себя Slowloris, атаки DDoS с нулевым дном, атаки DDoS, нацеленные на уязвимости Apache, Windows или OpenBSD и многое другое. Целью является сбой веб-сервера. Величина атаки измеряется в запросах в секунду.

*   **Attack Attack** - это также называется атакой уровня 7, где злоумышленник делает чрезмерную регистрацию, поиск базы данных или поисковые запросы для перегрузки приложения. На самом деле трудно обнаружить атаки уровня 7, поскольку они напоминают законный трафик веб-сайта.
    
*   **Slowloris** - злоумышленник отправляет огромное количество заголовков HTTP на целевой веб-сервер, но никогда не завершает запрос. Целевой сервер держит каждое из этих ложных подключений открытым и в конечном итоге переполняет максимальный параллельный пул соединений и приводит к отказу от дополнительных подключений от законных клиентов.
    
*   **Усиление NTP** . Злоумышленник использует общедоступные серверы сетевого времени (NTP) для подавления целевого сервера трафиком протокола пользовательских дейтаграмм (UDP).
    
*   **Атаки DDoS с** нулевым дном - Уязвимость с нулевым днем ​​- это недостаток системы или приложения, ранее неизвестный поставщику, и не был исправлен или исправлен. Это новый тип атак, возникающих изо дня в день, например, использование уязвимостей, для которых патч еще не выпущен.
    

### Как исправить атаку DDoS

Существует множество вариантов защиты DDoS, которые вы можете применять в зависимости от типа атаки DDoS.

Защита от DDoS начинается с определения и закрытия всех возможных уязвимостей на уровне ОС и уровня приложения в вашей системе, закрытия всех возможных портов, удаления ненужного доступа из системы и скрытия вашего сервера за прокси-сервером или системой CDN.

Если вы видите низкую величину DDoS, вы можете найти множество решений на базе брандмауэра, которые помогут вам в фильтрации трафика на основе DDoS. Но если у вас большой объем DDoS-атаки, например, в гигабитах или даже больше, то вам следует обратиться за помощью к поставщику услуг защиты DDoS, который предлагает более целостный, проактивный и подлинный подход.

Вы должны быть осторожны при приближении и выборе поставщика службы защиты DDoS. Существует ряд поставщиков услуг, которые хотят воспользоваться вашей ситуацией. Если вы сообщите им, что находитесь под атакой DDoS, тогда они начнут предлагать вам различные услуги по неоправданно высоким затратам.

Мы можем предложить вам простое и рабочее решение, которое начинается с поиска хорошего поставщика решений DNS, который достаточно гибкий, чтобы настроить записи A и CNAME для вашего сайта. Во-вторых, вам понадобится хороший поставщик CDN, который может обрабатывать большой трафик DDoS и предоставлять вам службу защиты DDoS как часть своего пакета CDN.

Предположим, что ваш IP-адрес вашего сервера - AAA.BBB.CCC.DDD. Затем вы должны выполнить следующую настройку DNS:

*   Создайте запись A в файле зоны DNS, как показано ниже, с идентификатором DNS, например ARECORDID, и сохраните его в тайне из внешнего мира.
*   Теперь попросите своего поставщика CDN связать созданный идентификатор DNS с URL-адресом, например cdn.someotherid.domain.com.
*   Вы будете использовать URL-адрес CDN cdn.someotherid.domain.com, чтобы создать две записи CNAME, причем первая должна указывать на www, а вторая запись - на @, как показано ниже.

Вы можете обратиться за помощью к своему системному администратору, чтобы понять эти моменты и настроить DNS и CDN соответствующим образом. Наконец, у вас будет следующая конфигурация в вашем DNS.

### Больше информации

*   [Понимание атак типа «отказ в обслуживании»](https://www.us-cert.gov/ncas/tips/ST04-015)
*   [Визуализация DDoS-атак по всему миру](http://www.digitalattackmap.com/#anim=1&color=0&country=ALL&list=0&time=17462&view=map "Визуализация DDoS-атак по всему миру")
*   [Kotaku Статья о DDoS](https://kotaku.com/how-ddos-attacks-work-and-why-theyre-so-hard-to-stop-1676445620)