---
title: Penetration Testing
localeTitle: Проверка на проницаемость
---
Тестирование проникновения - это метод, которым следуют многие компании, чтобы свести к минимуму их нарушения безопасности. Это контролируемый способ найма профессионала, который попытается взломать вашу систему и покажет вам лазейки, которые вам следует исправить. Испытания на проникновение могут иногда разрушать системы и заставлять компанию терять время безотказной работы, лучше всего проводить тест на проникновение на предварительную версию производственной среды.

Перед проведением теста на проникновение необходимо иметь соглашение, в котором будут прямо указываться следующие параметры:

*   какое будет время испытания на проникновение,
*   где будет IP-источник атаки, и
*   какими будут поля проникновения в систему.

Тесты на проникновение проводятся профессиональными этическими хакерами, которые в основном используют коммерческие инструменты с открытым исходным кодом, автоматизируют инструменты и ручные проверки. Нет никаких ограничений; самая важная цель здесь - выявить как можно больше недостатков безопасности. Многие крупные компании предлагают вознаграждения для всех, кто может указывать на уязвимости в своих системах, через так называемые [программы с ошибками](https://en.wikipedia.org/wiki/Bug_bounty_program) . Google, например, предложит десятки тысяч долларов через свою Программу вознаграждения за уязвимость.

## Фазы испытаний на проникновение

Существует пять основных этапов испытаний на проникновение. Они есть:

1.  **разведывательный**
    *   Именно здесь тестер проникновения собирает столько информации о ваших потенциальных целях. Некоторые методы, используемые на этом этапе, - поиск Google / Bing, поиск whois, сканирование Netcraft и социальная инженерия.
2.  **сканирование**
    *   Когда тестировщик проникновения собрал всю информацию и определил, на какую цель (а) они хотели бы атаковать, им необходимо убедиться, что цель (и) жива и сканировать такие вещи, как открытые порты, активные службы и любые текущие уязвимости что целевая система открыта.
3.  **эксплуатация**
    *   После того, как сканирование завершено и были оценены уязвимости, тестер проникновения может использовать эту информацию для определения своего вектора атаки. На этом этапе тестер проникновения ищет эксплойт, который использует одну из уязвимостей, обнаруженных на предыдущем этапе, чтобы получить доступ к целевой системе.
4.  **Доступ к Maintaing**
    *   Эта фаза - это то, где тестер проникновения гарантирует, что у них будет достаточно времени для проверки целевой системы. Они могут попытаться обойти любые меры по обнаружению / предотвращению вторжений, чтобы закончить их тестирование.
5.  **Покрытие треков**
    *   После того, как атака будет завершена, тестер пентации может предпринять шаги, чтобы скрыть их вторжение, и может, возможно, оставить после себя постоянный доступ, чтобы дать доказательство концепции своему клиенту.

## Типы испытаний на проникновение

У нас есть пять типов испытаний на проникновение -

1.  **Black Box.** Здесь этический хакер не имеет никакой информации о инфраструктуре или сети организации, которую он пытается проникнуть. В тестах проникновения черного ящика хакер пытается найти информацию своими силами.
    
2.  **Gray Box** - это тип тестирования на проникновение, где этический хакер имеет частичное знание инфраструктуры, например, своего сервера доменных имен.
    
3.  **White Box.** В тестах на проникновение в белые ящики этический хакер получает всю необходимую информацию об инфраструктуре и сети организации, которые ему необходимо пропустить.
    
4.  **Тестирование на внешнее проникновение.** Этот тип тестирования на проникновение в основном фокусируется на сетевой инфраструктуре или серверах и их программном обеспечении, работающем в рамках инфраструктуры. В этом случае этический хакер пытается атаковать, используя общедоступные сети через Интернет. Хакер пытается взломать инфраструктуру компании, нападая на их веб-страницы, веб-серверы, общедоступные DNS-серверы и т. Д.
    
5.  **Внутреннее тестирование проникновения.** В этом типе испытаний на проникновение этический хакер находится внутри сети компании и проводит свои тесты оттуда.
    

Тестирование на проникновение может также вызвать такие проблемы, как неисправность системы, сбой системы или потеря данных. Поэтому компания должна принимать расчетные риски перед тем, как продолжить тестирование на проникновение. Риск рассчитывается следующим образом, и это риск управления.

**RISK = Угроза × Уязвимость**

## пример

У вас есть онлайн-сайт электронной коммерции, который находится в производстве. Вы хотите пройти тест на проникновение, прежде чем делать это вживую. Здесь вы должны сначала взвесить плюсы и минусы. Если вы продолжите тестирование на проникновение, это может привести к прерыванию обслуживания. Напротив, если вы не хотите проходить тестирование на проникновение, вы можете рискнуть иметь незащищенную уязвимость, которая будет оставаться угрозой все время. Перед проведением теста на проникновение рекомендуется указать объем проекта в письменной форме. Вам должно быть ясно, что будет проверено. Например,

*   В вашей компании есть VPN или любые другие методы удаленного доступа, и вы хотите проверить эту конкретную точку.
*   В вашем приложении есть веб-серверы с базами данных, поэтому вы можете захотеть проверить его на атаки SQL-инъекций, что является одним из самых важных тестов на веб-сервере. Кроме того, вы можете проверить, не защищен ли ваш веб-сервер от DoS-атак.

## Быстрые советы

Перед тем, как пройти тест на проникновение, вы должны учитывать следующие моменты: Сначала поймите свои требования и оцените все риски.

*   Нанять сертифицированного человека для проведения теста на проникновение, потому что они обучены применять все возможные методы и методы, чтобы выявить возможные лазейки в сети или веб-приложении.
*   Всегда подписывайте соглашение, прежде чем проходить тест на проникновение.

## Ресурсы

[Проверка на проницаемость](https://en.wikipedia.org/wiki/Penetration_test)