---
title: Scanning
localeTitle: сканирование
---
# сканирование

## Введение

Сетевое сканирование относится к набору процедур для указания хостов, сообщений и служб в сети.

Действия сканирования могут включать проверку открытых портов в сети, захват баннеров и создание сетевых диаграмм.

## Сканирование

Одним из наиболее распространенных способов сканирования сети является метод Ping Sweep. Это может определять живые хосты на разных IP-адресах. Очень простой пример этого - просто перейти к вашей командной строке и набрать `ping 8.8.8.8` . Это отправит [ICMP-](https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol) запрос ECHO на хост, в этом случае это будет публичный DNS Google.

Различные интернет-протоколы требуют разных методов сканирования; например, сканирование сети [TCP](https://en.wikipedia.org/wiki/Transmission_Control_Protocol) будет отличаться от сканирования сети [UDP](https://en.wikipedia.org/wiki/User_Datagram_Protocol) .

Проверки TCP обычно используют то, как работает TCP, и как TCP проходит через «рукопожатие» для инициирования связи в сети:

1.  Устройство (хост A) отправит `SYN` сообщение в попытке установить связь по сети на другое устройство (сервер B)
2.  B должен ответить на A с `SYN` и `ACK` чтобы подтвердить запрос A для начала связи
3.  Необходимо отправить сообщение `ACK` для подтверждения ответа B
4.  Связь может начаться

На протяжении всего этого сообщения есть бит информации, которую каждый участник отправляет в попытке инициировать разговор.

Обратите внимание, что вы также можете сканировать сети IPv6 (IPv6 увеличивает размер IP-адреса, чтобы сделать намного больше доступных адресов).

Существует гораздо больше типов [сканирований,](https://nmap.org/bennieston-tutorial/) которые еще больше нарушают процесс рукопожатия TCP. К ним относятся IDLE-сканирование, сканирование Xmas-дерева, обратные проверки TCP и полные сканы.

## Сканирование при тестировании проницаемости

Сканирование является второй фазой из типичных пяти этапов испытаний на проникновение. Фаза сканирования требует применения технических средств для сбора дополнительной информации о вашей цели, но в этом случае запрашиваемая Intel чаще всего относится к системам, которые они имеют. 1

Существуют три основные цели:

1.  Определение того, жив ли система
2.  Порт сканирования системы
3.  Сканирование системы на наличие уязвимостей 2

### Определение того, жив ли система

Один из способов определить, жив ли целевая система, - это использовать команду **ping** , как указано выше в технике Ping Sweep.

Например:
```
ping <target_ip_address> -c <number_of_packets_to_send> 
 ping 10.10.0.1 -c 4 
```

Если целевая система жива, вы должны получить ответ, похожий на приведенный ниже.
```
Pinging 10.10.0.1 with 32 bytes of data: 
 
 Reply from 10.0.0.1: bytes=32 time=26ms TTL=240 
 Reply from 10.0.0.1: bytes=32 time=26ms TTL=240 
 Reply from 10.0.0.1: bytes=32 time=26ms TTL=240 
 Reply from 10.0.0.1: bytes=32 time=26ms TTL=240 
 Ping statistics for 10.10.0.1: 
    Packets: Sent = 4, Received = 4, Lost = 0 (0% loss), 
 Approximate round trip times in milliseconds: 
    Minimum = 26ms, Maximum = 26ms, Average = 26ms 
```

*   **Reply from** указывает, что наш ICMP-запрос Echo Request был получен, пакет ICMP Echo Reply был отправлен обратно.
*   **Bytes = 32** сообщает нам, что размер отправленного пакета.
*   **time = 26ms** позволяет нам узнать, как в совокупное время пакет ICMP Echo Request попал в цель и для пакета ICMP Echo Reply вернется на наш компьютер.
*   **TTL = 240** - это значение Time To Live, которое сообщает нам максимальное количество переходов, которые пакет будет принимать до того, как он упадет.

## Сканирующие инструменты

Существует множество инструментов для сканирования, но одним из наиболее распространенных является `nmap` . Это полезный инструмент с такими функциями, как получение информации о реальных хостах в сети, запущенных сервисах и типах и версиях используемой операционной системы.

## Дополнительная информация:

*   Как выполнить Ping в Linux https://www.wikihow.com/Ping-in-Linux
*   [Видео от Гордона Лиона aka Fydor, создателя инструмента nmap](https://www.youtube.com/watch?v=Hk-21p2m8YY)

## источники

1.  Подведение итогов пяти этапов испытаний на проникновение. (2015, май 06). Получено 26 октября 2017 года, из https://www.cybrary.it/2015/05/summarizing-the-five-phases-of-penetration-testing/

3.  Engebretson, P. (2013). Основы тестирования взлома и проникновения: этические испытания взлома и проникновения сделали Easy Ed. 2. Синхронизация.