---
title: Steganography
localeTitle: стеганография
---
## стеганография

Стеганография - это концепция уступающего текста, изображений, файлов или видео в другом тексте, изображениях, файлах или видео. В автономном примере это использование «невидимых чернил», чтобы скрыть сообщение между строками буквы. Лимонный сок - популярный кандидат на невидимые чернила: [лимонный сок невидимые чернила](https://www.youtube.com/embed/poCnU_crpjQ)

Следующая формула дает очень общее описание частей стеганографического процесса:

обложка _\+ скрытые_ данные + стеганографический _ключ =_ среда для _стенографии_

В этом контексте _среда_ обложки _\- это файл, который скрывает скрытые_ данные, которые также могут быть зашифрованы с помощью стеганографического _ключа. Результирующим файлом является_ среда _стеганографии_ . Покровный _носитель (и, следовательно, стеганографический_ носитель) обычно представляют собой изображения или аудиофайлы.

### Стеганография в изображениях

На компьютерах изображения хранятся в виде двоичных файлов. Они содержат двоичное представление цвета или интенсивности света каждого элемента изображения (пикселя), содержащего изображение. Например, это изображение собаки:

![американская эскимосская собака](https://upload.wikimedia.org/wikipedia/commons/4/47/American_Eskimo_Dog.jpg)

может начаться с чего-то вроде:
```
10010101   00001101   11001001 
 10010110   00001111   11001010 
 10011111   00010000   11001011 
 ... 
```

Самый простой подход к сокрытию данных в файле изображения называется вставкой младшего разряда (LSB). В этом методе мы можем взять двоичное представление скрытых _данных и перезаписать младший бит каждого байта в обложке_ . Если мы используем 24-битный цвет, количество изменений будет минимальным и неотличимым от человеческого глаза.

Хотя JPEG можно использовать для приложений stego, более распространено встраивание данных в файлы GIF или BMP. GIF и 8-битные файлы BMP используют так называемое сжатие без потерь, схему, которая позволяет программному обеспечению точно восстанавливать исходное изображение. JPEG, с другой стороны, использует сжатие с потерями, а это означает, что расширенное изображение практически не отличается от оригинала, но не является точным дубликатом.

Эта короткая демонстрация поможет вам настроить текст с кодировкой в ​​изображении! https://github.com/edwdryer/steganography-demo Вы можете прочитать больше о стеганографии в изображениях здесь: http://www.garykessler.net/library/steganography.html

### Стеганография в аудио

Аудио-стеганография - это метод, используемый для передачи скрытой информации путем изменения звукового сигнала незаметным образом.

Этот blogpost служит примером сокрытия изображения в аудио-файле (ничего себе)! https://solusipse.net/blog/post/basic-methods-of-audio-steganography-spectrograms/