---
title: Traceroute
localeTitle: Трассировка
---
**Оглавление**

*   [Трассировка](#traceroute)
*   [Как данные перемещаются через Интернет](#how-data-travels-across-the-internet)
*   [Некоторые примеры использования](#some-examples-for-usage)
*   [Дополнительная информация](#more-information)

## Трассировка

Traceroute - это диагностический инструмент компьютерной сети для отображения маршрута (пути) и измерения транзитных задержек пакетов через сеть Интернет-протокола (IP). История маршрута записывается как время обратного хода пакетов, полученных от каждого последующего хоста (удаленного узла) в маршруте (пути); сумма средних времен в каждом прыжке является мерой общего времени, затраченного на установление соединения. Traceroute продолжается, если все (три) отправленные пакеты теряются более чем в два раза, тогда соединение теряется и маршрут не может быть оценен. Ping, с другой стороны, вычисляет только конечное время прохода туда и обратно.

#### Как данные перемещаются через Интернет

Каждый компьютер в traceroute идентифицируется по его IP-адресу, который представляет собой девятизначное число, разделенное периодами, которые идентифицируют уникальное сетевое соединение этого компьютера. Вот несколько деталей относительно traceroute:
```
- The journey from one computer to another is known as a hop. 
 - The amount of time it takes to make a hop is measured in milliseconds. 
 - The information that travels along the traceroute is known as a packet. 
```

В показателе traceroute обычно отображаются три отдельных столбца для времени перерыва, так как каждый трассировочный объект отправляет три отдельных пакета информации на каждый компьютер. В самом верху списка, traceroute даст предел количества строк хмеля, которые он отобразит, - 30 прыжков часто являются максимальным числом.

Когда traceroute испытывает трудности с доступом к компьютеру, он отобразит сообщение «Время ожидания запроса». Каждый из столбцов перескока отображает звездочку вместо миллисекундного счета.

#### Некоторые примеры использования

Большинство реализаций включают, по крайней мере, опции для указания количества запросов для отправки на скачок, времени ожидания ответа, предела перехода и используемого порта. Вызов traceroute без определенных параметров отображает список доступных параметров, в то время как man traceroute представляет более подробную информацию, включая отображаемые флаги ошибок. Простой пример в Linux:
```
[root@example ~]#  traceroute -w 3 -q 1 -m 16 www.google.com 
 traceroute to www.google.com (216.58.200.36), 16 hops max, 60 byte packets 
 1  192.168.4.2 (192.168.4.2)  0.136 ms 
 2  * 
 3  * 
 4  * 
 5  * 
 6  * 
 7  * 
 8  * 
 9  * 
 10  * 
 11  * 
 12  * 
 13  * 
 14  * 
 15  * 
 16  * 
```

В приведенном выше примере выбранные параметры должны ждать три секунды (вместо пяти), отправлять только один запрос на каждый прыжок (вместо трех), ограничивать максимальное количество переходов до 16 перед сдачей (вместо 30), с www.google.com в качестве конечного хоста.

Это может помочь определить неверные определения таблиц маршрутизации или брандмауэры, которые могут блокировать трафик ICMP или высокий порт UDP в сеансе Unix на сайте. Обратите внимание, что брандмауэр может разрешать пакеты ICMP, но не разрешать пакеты других протоколов.

Traceroute также используется тестировщиками проникновения для сбора информации о сетевой инфраструктуре и диапазонах IP-адресов вокруг определенного хоста.

Его также можно использовать при загрузке данных, и если доступно несколько зеркал для одной и той же части данных, можно проследить каждое зеркало, чтобы получить представление о том, какое зеркало будет самым быстрым в использовании.

#### Больше информации

Читайте больше информации о Traceroute:

*   [Как использовать TRACERT в Windows](https://support.microsoft.com/en-us/help/314868/how-to-use-tracert-to-troubleshoot-tcp-ip-problems-in-windows) - [Как использовать TRACERT в Linux](https://www.lifewire.com/traceroute-linux-command-4092586)