---
title: Wireshark
localeTitle: Wireshark
---
## Wireshark

Wireshark - приложение для анализа сетевых приложений с открытым исходным кодом, которое доступно для Linux, MacOS и Windows. Это позволяет вам «обнюхивать» [пакеты](../../network-engineering/packets/) , отправляемые в и из разных узлов сети.

#### Зачем использовать Wireshark?

Wireshark - мощный инструмент, вы можете использовать его для:

*   Узнайте, как различные протоколы используются в сети
*   Устранение сетевых проблем
*   Анализ трафика, проходящего через вашу сеть
*   Анализ данных, передаваемых вашим программным обеспечением на удаленные серверы
*   Убедитесь, что данные были правильно зашифрованы перед отправкой
*   Разработка сетевых протоколов
*   Проверьте наличие [троянов](../trojans/) или другого вредоносного программного обеспечения на вашем компьютере

#### Как мне начать?

Использовать Wireshark в своей основной форме:

1.  [Загрузите](https://www.wireshark.org/download.html) и установите приложение.
2.  Выберите `interface` вы хотите захватить пакеты, это скорее всего будет вашим сетевым или WiFi-адаптером.
3.  Наблюдайте за красивым потоком цветных кодированных пакетов и позволяйте приложению захватывать их столько, сколько захотите.
4.  Когда у вас достаточно пакетов, выберите кнопку остановки.
5.  Сохраните захваченные пакеты, если вы хотите сохранить их для постоянного анализа. Это делается как файл `.pcap` который является стандартным форматом для _захвата пакетов_ .

![Screenshot of Wireshark on MacOS](https://thejayhaykid.github.io/images/Wireshark.png "Wireshark на MacOS")

#### Анализ, фильтрация и проверка

Теперь у вас есть куча пакетов, но что все это значит? Различные цвета, которые вы видели, указывают на разные типы трафика. По умолчанию некоторые из цветов:

*   Light purple - пакеты протокола управления передачей (TCP);
*   Голубой - пакеты пользовательских дейтаграмм (UDP);
*   Черный - ошибки

> Примечание. Эти цвета могут быть настроены, но помните, что каждый пакет может вписываться в более чем одну категорию, поэтому вы также должны устанавливать приоритеты для этих правил.

Фильтрация ваших пакетов - это быстрый способ найти то, что вы ищете. Просто введите текст в верхней части окна, чтобы отобразить только пакеты, соответствующие вашему запросу. Например, если вы [просматриваете трафик HTTPS](https://en.wikiversity.org/wiki/Wireshark/HTTPS) , введите `ssl` в фильтр. Это покажет все пакеты, связанные с соединениями HTTPS.

Теперь, когда вы нашли некоторые соответствующие пакеты, выберите один, чтобы просмотреть более подробную информацию об этом. В зависимости от типа пакета, который вы проверяете, это даст вам много подробной информации. Некоторые основные детали будут включать:

*   Используемый протокол
*   Адрес источника и порт
*   Адрес и порт назначения
*   Время отклика

### Дополнительная информация:

[Wireshark.org](https://www.wireshark.org)  
[Wireshark - Википедия](https://en.wikipedia.org/wiki/Wireshark)  
[Как использовать Wireshark для захвата, фильтрации и проверки пакетов - как выучить](https://www.howtogeek.com/104278/how-to-use-wireshark-to-capture-filter-and-inspect-packets/)