---
title: XSS Cross Site Scripting
localeTitle: XSS Cross Site Scripting
---
## XSS Cross Site Scripting

Cross Site Scripting (XSS) - это тип инъекции кода. Это одна из самых распространенных уязвимостей в Интернете.

XSS обычно включает ввод кода в форму, параметр url или где-либо еще, который принимает пользовательский ввод, который отображается обратно пользователям. Например, представьте себе веб-сайт, на котором был показан ваш профиль пользователя, и вы ввели `<script>alert("HELLO!");</script>` качестве вашего имени пользователя. Если сайт не помешал XSS, каждый пользователь, посетивший ваш профиль, получит всплывающее предупреждение.

#### Различные типы XSS

Существует 3 разных типа XSS.

*   Сохраненный XSS
*   Светоотражающий XSS
*   Основанный на DOM XSS

#### Опасности XSS

Конечно, приведенный выше пример не представляет непосредственной опасности для тех, кто просматривает ваш профиль. Но что, если у вас были более зловещие намерения? Вы можете выполнить некоторый javascript, чтобы показать страницу поддельного входа, и собрать имена пользователей и пароли для других пользователей сайта или просто прочитать файл cookie сеанса, если он небезопасен. Вы можете заставить их посетить другие веб-сайты или выполнить какое-либо действие.

#### Защищать от XSS

*   Никогда не доверяйте данным пользователя
*   Проверяйте ненадежные данные (проверяйте правильность данных, если они недействительны, отклоняют, а не обрабатывают)
*   Безопасные значения белого списка (а не черный список)
*   Всегда кодировать вывод
*   Кодировка для правильного контекста (атрибуты HTML / HTML / CSS / JSS - все разные)
*   Защита файлов cookie (только HTTP и защита могут быть прочитаны только сервером)
*   Внедрение политики безопасности контента

#### Дополнительная информация:

Ознакомьтесь с дополнительной информацией о XSS и о шагах, которые вы можете предпринять для защиты от:

[Межсайтовый скриптинг (XSS)](https://www.owasp.org/index.php/Cross-site_Scripting_(XSS) )

[Предупреждение об ошибках OWASP XSS (Cross Site Scripting)](https://www.owasp.org/index.php/XSS_(Cross_Site_Scripting)

[Hacksplaining XSS Lesson](https://www.hacksplaining.com/exercises/xss-stored)