---
title: Code Coverage
localeTitle: Охват кода
---
## Охват кода

Когда вы запускаете автоматические тесты программного обеспечения для поиска ошибок, **охват кода** - это измерение того, какая часть кода, который вы тестируете, фактически выполняется во время тестов.

Код, который не был выполнен во время тестирования, по определению не был протестирован и поэтому может содержать ошибки. Так что, вообще говоря, более высокий охват кода, описанный в тестовом наборе, тем меньше вероятность того, что ошибки будут незаметны.

Это не означает, что 100% -ное покрытие кода означает 0% -ный шанс ошибок, однако! Легко представить себе ситуацию, когда все доступные функции в куске кода вызываются, но не обязательно, с входами, представляющими все типы сценариев, которые вы могли бы ожидать от реальных пользователей.

Внутри и вне того, как покрытие кода не будет представлять большой интерес, пока вы на самом деле не используете автоматическое тестирование и не пытаетесь сделать это эффективно.

#### Больше информации

[Википедия - охват кода](https://en.wikipedia.org/wiki/Code_coverage)

[freeCodeCamp Guide - Разработка, управляемая тестированием](https://guide.freecodecamp.org/agile/test-driven-development)

[freeCodeCamp Guide - Единичные тесты](https://guide.freecodecamp.org/software-engineering/unit-tests)

[freeCodeCamp Guide - Непрерывная интеграция](https://guide.freecodecamp.org/agile/continuous-integration)