---
title: Finite State Machine
localeTitle: Конечный автомат
---
Конечный автомат (FSM) представляет собой шаблон проектирования программного обеспечения, в котором данная модель переходит в другие поведенческие состояния через внешний вход.

## Конечный автомат

FSM определяется его **состояниями** , это **начальное состояние** и **переходы** .

Сила FSM - это способность четко различать _поведение_ в разных условиях. Обычно FSM используется с циклическими поведенческими сценариями, которые постоянно оценивают текущую ситуацию в цикле или событиях.

Чтобы помочь сформировать образ того, как это может быть применено, кофе-машина будет использоваться в качестве примера конечного автомата. Мы также рассмотрим диаграмму состояний, чтобы визуализировать FSM и представить примеры кодирования.

### Диаграмма состояния

![Диаграмма конечного автомата кофе-машины](https://raw.githubusercontent.com/arunma/blogimages/master/AkkaFSM/CoffeeMachineFSM.png) На этой диаграмме показаны три возможных состояния для кофеварки:

*   открыто
*   ReadyToBuy
*   PoweredOff

Линии между этими состояниями показывают, какие переходы возможны между состояниями и в каком направлении. Эти переходы имеют условия, когда FSM необходимо изменить между состояниями.

*   StartUpMachine От состояния PoweredOff до состояния Open машина должна запускаться. В этом случае это делается вручную.
    
*   депозит> = стоимость кофе FSM оценивает сумму депонированных денежных средств либо в цикле, либо когда сумма изменяется (рекомендуется в этом случае) Если вы вложите достаточно денег в кофемашину, FSM перейдет от «Открыть» к «ReadyToBuy».
    
*   ShutdownMachine Машина автоматически перейдет от Open к PoweredOff с помощью метода ShutDownMachine, если условие «больше не осталось кофе» выполнено.
    
*   DispenseCoffee В состоянии ReadyToBuy пользователь может купить кофе, после чего его варят и выдают. Условие заключается в том, когда происходит событие BuyCoffee (! Ссылка на шаблон наблюдателя!). (не показано на диаграмме)
    
*   CancelCoffee Если пользователь решит отменить, аппарат перейдет из ReadyToBuy в Open.
    
*   ShutDownMachine Машина перейдет в состояние PoweredOff
    

### состояния

В каждом состоянии определено поведение, которое будет выполняться только тогда, когда объект находится в этом состоянии. Например, во время работы PowerOff кофеварка не будет заваривать кофе до того, как он будет включен, во время Открытого состояния он будет ждать либо до тех пор, пока не будет введено достаточно денег, пока не будет подана команда по отключению питания, или пока не закончится кофе. Во время этого открытого состояния он может выполнять такие процедуры, как очистка, которая не будет выполняться в других состояниях.

### Начальное состояние

Каждое FSM имеет начальное состояние, это означает, какое состояние оно начинает, когда оно создается, и должно быть определено при построении или инстанцировании. Конечно, при выполнении условий можно напрямую изменить состояние.

### Переходы

Каждое государство либо постоянно оценивает, должно ли оно переходить в другое состояние, либо перейдет в другое состояние на основе инициированного события.

## DFA и NFA

Существует два типа конечного автомата: детерминированный (DFA) и недетерминированный (NFA). Оба они принимают обычные языки и работают более или менее точно так же, как описано выше, однако с некоторыми отличиями.

DFA принимает или отклоняет строку символов и производит только одно уникальное вычисление или автомат для каждой входной строки. _Детерминистский_ относится к единственности вычислений. Машина конечного состояния называется DFA, если она подчиняется следующим правилам:

1.  Каждый из его переходов _однозначно_ определяется его исходным состоянием и входным символом
2.  Чтение входного символа требуется для каждого перехода состояния.

NFA не нуждается в соблюдении этих ограничений, что означает, что каждый DFA также является NFA. И поскольку они оба распознают только обычные языки, каждая NFA может быть преобразована в эквивалентный DFA с использованием алгоритма построения схемы.

Итак, какие правила мы можем ожидать в NFA, но не в DFA?

1.  NFA может иметь _пустой строковый_ переход (обычно обозначаемый epsilon). Это означает, что когда в определенном состоянии с epsilon для правила перехода, машина может перейти в следующее состояние без считывания входного символа
2.  В NFA каждая пара состояния и символ перехода могут иметь несколько состояний назначения в отличие от уникальных мест назначения пар в DFA
3.  Каждая пара символов состояния и перехода создает «ветвь» вычисления для каждого из возможных вариантов назначения, создавая какую-то многопоточную систему.
4.  DFA отклоняет входную строку, если она приземляется на любое состояние, отличное от состояния принятия. В NFA нам нужна только одна «ветка» для приземления в состоянии принятия, чтобы принять строку.